/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import io.mangoo.enums.Required;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class ByteUtils {
    private static final int BYTES = 8;
    private static final int MAX_BYTE_LENGTH = 0xFFFFFFF;

    private ByteUtils() {
    }

    public static int bitLength(byte[] byArray) {
        Objects.requireNonNull(byArray, Required.BYTES.toString());
        int n = byArray.length;
        int n2 = 0;
        if (n <= 0xFFFFFFF && n > 0) {
            n2 = n * 8;
        }
        return n2;
    }

    public static int bitLength(String string) {
        Objects.requireNonNull(string, Required.STRING.toString());
        int n = string.getBytes(StandardCharsets.UTF_8).length;
        int n2 = 0;
        if (n <= 0xFFFFFFF && n > 0) {
            n2 = n * 8;
        }
        return n2;
    }
}

