/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ReadContext;
import io.mangoo.enums.Required;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JsonUtils {
    private static final Logger LOG = LogManager.getLogger(JsonUtils.class);
    private static ObjectMapper mapper = new ObjectMapper();

    private JsonUtils() {
    }

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static String toJson(Object object) {
        Objects.requireNonNull(object, Required.OBJECT.toString());
        String string = null;
        try {
            string = mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            LOG.error("Failed to convert object to json", (Throwable)jsonProcessingException);
        }
        return string;
    }

    public static String toPrettyJson(Object object) {
        Objects.requireNonNull(object, Required.OBJECT.toString());
        String string = null;
        try {
            string = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            LOG.error("Failed to convert object to json", (Throwable)jsonProcessingException);
        }
        return string;
    }

    public static ReadContext fromJson(String string) {
        Objects.requireNonNull(string, Required.JSON.toString());
        return JsonPath.parse((String)string);
    }

    public static <T> T fromJson(String string, Class<T> clazz) {
        Objects.requireNonNull(string, Required.JSON.toString());
        Objects.requireNonNull(clazz, Required.CLASS.toString());
        Object object = null;
        try {
            object = mapper.readValue(string, clazz);
        }
        catch (IOException iOException) {
            LOG.error("Failed to convert json to object class", (Throwable)iOException);
        }
        return (T)object;
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

