/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mangoo.enums.Default;
import io.mangoo.enums.Required;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MangooUtils {
    private static final Logger LOG = LogManager.getLogger(MangooUtils.class);
    private static final String[] UNITS = new String[]{"B", "kB", "MB", "GB", "TB"};
    private static final char[] CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    private static final int MAX_PASSWORD_LENGTH = 256;
    private static final int MIN_PASSWORD_LENGTH = 0;
    private static final int CONVERTION = 1024;

    private MangooUtils() {
    }

    @SuppressFBWarnings(justification="Only used to retrieve the version of mangoo I/O", value={"URLCONNECTION_SSRF_FD"})
    public static String getVersion() {
        String string = Default.VERSION_UNKNOW.toString();
        try (InputStream inputStream = Resources.getResource((String)Default.VERSION_PROPERTIES.toString()).openStream();){
            Properties properties = new Properties();
            properties.load(inputStream);
            string = String.valueOf(properties.get("version"));
        }
        catch (IOException iOException) {
            LOG.error("Failed to get application version", (Throwable)iOException);
        }
        return string;
    }

    public static Map<String, String> copyMap(Map<String, String> map) {
        Objects.requireNonNull(map, Required.MAP.toString());
        return new HashMap<String, String>(map);
    }

    public static String randomString(int n) {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"random string length must be at least 1 character");
        Preconditions.checkArgument((n <= 256 ? 1 : 0) != 0, (Object)"random string length must be at most 256 character");
        return RandomStringUtils.random((int)n, (int)0, (int)(CHARACTERS.length - 1), (boolean)false, (boolean)false, (char[])CHARACTERS, (Random)new SecureRandom());
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            LOG.error("Failed to close resource quietly", (Throwable)iOException);
        }
    }

    public static String readableFileSize(long l) {
        if (l <= 0L) {
            return "0";
        }
        int n = (int)(Math.log10(l) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)l / Math.pow(1024.0, n)) + " " + UNITS[n];
    }

    public static boolean resourceExists(String string) {
        Objects.requireNonNull(string, Required.NAME.toString());
        URL uRL = null;
        try {
            uRL = Resources.getResource((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uRL != null;
    }
}

