/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.google.common.net.MediaType;
import com.google.re2j.Pattern;
import dev.paseto.jpaseto.PasetoException;
import dev.paseto.jpaseto.Pasetos;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.enums.Header;
import io.mangoo.enums.Required;
import io.mangoo.models.Identity;
import io.mangoo.routing.Attachment;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.sse.ServerSentEventConnection;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.websockets.core.WebSocketChannel;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RequestUtils {
    private static final Logger LOG = LogManager.getLogger(RequestUtils.class);
    private static AttachmentKey<Attachment> attachmentKey;
    private static final String READ = "read";
    private static final String WRITE = "write";
    private static final Pattern PATTERN;

    private RequestUtils() {
    }

    public static AttachmentKey<Attachment> getAttachmentKey() {
        if (attachmentKey == null) {
            attachmentKey = AttachmentKey.create(Attachment.class);
        }
        return attachmentKey;
    }

    public static Map<String, String> getRequestParameters(HttpServerExchange httpServerExchange) {
        Objects.requireNonNull(httpServerExchange, Required.HTTP_SERVER_EXCHANGE.toString());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map map = httpServerExchange.getQueryParameters();
        map.putAll(httpServerExchange.getPathParameters());
        map.entrySet().forEach(entry -> hashMap.put((String)entry.getKey(), (String)((Deque)entry.getValue()).element()));
        return hashMap;
    }

    public static boolean isPostPutPatch(HttpServerExchange httpServerExchange) {
        Objects.requireNonNull(httpServerExchange, Required.HTTP_SERVER_EXCHANGE.toString());
        return Methods.POST.equals(httpServerExchange.getRequestMethod()) || Methods.PUT.equals(httpServerExchange.getRequestMethod()) || Methods.PATCH.equals(httpServerExchange.getRequestMethod());
    }

    public static boolean isJsonRequest(HttpServerExchange httpServerExchange) {
        Objects.requireNonNull(httpServerExchange, Required.HTTP_SERVER_EXCHANGE.toString());
        HeaderMap headerMap = httpServerExchange.getRequestHeaders();
        return headerMap != null && headerMap.get(Header.CONTENT_TYPE.toHttpString()) != null && headerMap.get(Header.CONTENT_TYPE.toHttpString()).element().toLowerCase(Locale.ENGLISH).contains(MediaType.JSON_UTF_8.withoutParameters().toString());
    }

    public static boolean hasValidAuthentication(String string) {
        boolean bl = false;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            String[] stringArray;
            Config config = Application.getInstance(Config.class);
            String string2 = null;
            for (String string3 : stringArray = string.split(";")) {
                if (!StringUtils.isNotBlank((CharSequence)string3) || !string3.startsWith(config.getAuthenticationCookieName())) continue;
                string2 = StringUtils.substringAfter((String)string3, (String)(config.getAuthenticationCookieName() + "="));
                string2 = PATTERN.matcher((CharSequence)string2).replaceAll("");
            }
            if (StringUtils.isNotBlank(string2)) {
                try {
                    Pasetos.parserBuilder().setSharedSecret(config.getAuthenticationCookieSecret().getBytes(StandardCharsets.UTF_8)).build().parse(string2);
                    bl = true;
                }
                catch (PasetoException pasetoException) {
                    LOG.error("Failed to parse authentication cookie", (Throwable)pasetoException);
                }
            }
        }
        return bl;
    }

    public static String getServerSentEventURL(ServerSentEventConnection serverSentEventConnection) {
        return RequestUtils.getURL(URI.create(serverSentEventConnection.getRequestURI()));
    }

    public static String getWebSocketURL(WebSocketChannel webSocketChannel) {
        return RequestUtils.getURL(URI.create(webSocketChannel.getUrl()));
    }

    public static String getURL(URI uRI) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(uRI.getPath());
        String string = uRI.getQuery();
        String string2 = uRI.getFragment();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            stringBuilder.append('?').append(string);
        }
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            stringBuilder.append('#').append(string2);
        }
        return stringBuilder.toString();
    }

    public static HttpHandler wrapBasicAuthentication(HttpHandler httpHandler, String string, String string2) {
        Objects.requireNonNull(httpHandler, Required.HTTP_HANDLER.toString());
        Objects.requireNonNull(string, Required.USERNAME.toString());
        Objects.requireNonNull(string2, Required.PASSWORD.toString());
        AuthenticationCallHandler authenticationCallHandler = new AuthenticationCallHandler(httpHandler);
        authenticationCallHandler = new AuthenticationConstraintHandler((HttpHandler)authenticationCallHandler);
        authenticationCallHandler = new AuthenticationMechanismsHandler((HttpHandler)authenticationCallHandler, Collections.singletonList(new BasicAuthenticationMechanism("Authentication required")));
        return new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, (IdentityManager)new Identity(string, string2), (HttpHandler)authenticationCallHandler);
    }

    public static String getOperation(HttpString httpString) {
        String string = "";
        if (Methods.POST.equals(httpString)) {
            string = WRITE;
        } else if (Methods.PUT.equals(httpString)) {
            string = WRITE;
        } else if (Methods.DELETE.equals(httpString)) {
            string = WRITE;
        } else if (Methods.GET.equals(httpString)) {
            string = READ;
        } else if (Methods.PATCH.equals(httpString)) {
            string = WRITE;
        } else if (Methods.OPTIONS.equals(httpString)) {
            string = READ;
        } else if (Methods.HEAD.equals(httpString)) {
            string = READ;
        }
        return string;
    }

    static {
        PATTERN = Pattern.compile((String)"\"");
    }
}

