/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.admin;

import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.inject.Inject;
import com.google.re2j.Pattern;
import io.mangoo.admin.AdminFilter;
import io.mangoo.admin.AdminUtils;
import io.mangoo.annotations.FilterWith;
import io.mangoo.async.EventBus;
import io.mangoo.cache.Cache;
import io.mangoo.cache.CacheImpl;
import io.mangoo.cache.CacheProvider;
import io.mangoo.constants.Template;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.crypto.Crypto;
import io.mangoo.exceptions.MangooEncryptionException;
import io.mangoo.models.Metrics;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.bindings.Request;
import io.mangoo.scheduler.Scheduler;
import io.mangoo.utils.MangooUtils;
import io.mangoo.utils.totp.TotpUtils;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import java.security.KeyPair;
import java.security.PublicKey;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdminController {
    private static final Logger LOG = LogManager.getLogger(AdminController.class);
    private static final Pattern PATTERN = Pattern.compile((String)"[^a-zA-Z0-9]");
    private static final String ENABLED = "enabled";
    private static final String ADMIN_INDEX = "/@admin";
    private static final String PERIOD = "30";
    private static final String DIGITS = "6";
    private static final String METRICS = "metrics";
    private static final double HUNDRED_PERCENT = 100.0;
    private final CacheProvider cacheProvider;
    private final Cache cache;
    private final Config config;
    private final Crypto crypto;

    @Inject
    public AdminController(Config config, CacheProvider cacheProvider, Crypto crypto) {
        this.config = Objects.requireNonNull(config, "config can not be null");
        this.cache = cacheProvider.getCache("mangooio-application-cache");
        this.cacheProvider = Objects.requireNonNull(cacheProvider, "cacheProvider can not be null");
        this.crypto = Objects.requireNonNull(crypto, "crypto can not be null");
    }

    @FilterWith(value={AdminFilter.class})
    public Response index() {
        Instant instant = Application.getStart().atZone(ZoneId.systemDefault()).toInstant();
        boolean bl = this.config.isMetricsEnable();
        EventBus eventBus = Application.getInstance(EventBus.class);
        if (bl) {
            Metrics metrics = Application.getInstance(Metrics.class);
            long l = 0L;
            long l2 = 0L;
            for (Map.Entry<Integer, LongAdder> entry : metrics.getResponseMetrics().entrySet()) {
                if (String.valueOf(entry.getKey()).charAt(0) == '5') {
                    l2 += entry.getValue().longValue();
                }
                l += entry.getValue().longValue();
            }
            double d = 0.0;
            if (l2 > 0L) {
                d = 100.0 / (double)l * (double)l2;
            }
            return Response.withOk().andContent(ENABLED, Boolean.TRUE).andContent(METRICS, metrics.getResponseMetrics()).andContent("uptime", Date.from(instant)).andContent("warnings", this.cache.get("MANGOOIO-WARNINGS")).andContent("dataSend", MangooUtils.readableFileSize(metrics.getDataSend())).andContent("totalRequests", l).andContent("minRequestTime", metrics.getMinRequestTime()).andContent("avgRequestTime", metrics.getAvgRequestTime()).andContent("maxRequestTime", metrics.getMaxRequestTime()).andContent("errorRate", d).andContent("events", eventBus.getHandledEvents()).andContent("subscribers", eventBus.getNumberOfSubscribers()).andTemplate(Template.adminPath());
        }
        return Response.withOk().andContent(ENABLED, Boolean.FALSE).andContent("uptime", Date.from(instant)).andContent("events", eventBus.getHandledEvents()).andContent("subscribers", eventBus.getNumberOfSubscribers()).andContent("warnings", this.cache.get("MANGOOIO-WARNINGS")).andTemplate(Template.adminPath());
    }

    @FilterWith(value={AdminFilter.class})
    public Response cache() {
        HashMap<String, CacheStats> hashMap = new HashMap<String, CacheStats>();
        for (Map.Entry<String, Cache> entry : this.cacheProvider.getCaches().entrySet()) {
            hashMap.put(entry.getKey(), ((CacheImpl)entry.getValue()).getStats());
        }
        return Response.withOk().andContent("statistics", hashMap).andTemplate(Template.cachePath());
    }

    @FilterWith(value={AdminFilter.class})
    public Response scheduler() {
        Scheduler scheduler = Application.getInstance(Scheduler.class);
        return Response.withOk().andContent("scheduler", scheduler).andTemplate(Template.schedulerPath());
    }

    @FilterWith(value={AdminFilter.class})
    public Response tools() {
        String string = this.config.getApplicationAdminSecret();
        String string2 = null;
        if (StringUtils.isBlank((CharSequence)string)) {
            string = TotpUtils.createSecret();
            string2 = TotpUtils.getQRCode("mangoo_IO_Admin", PATTERN.matcher((CharSequence)this.config.getApplicationName()).replaceAll(""), string, "SHA512", DIGITS, PERIOD);
        }
        return Response.withOk().andContent("qrcode", string2).andContent("secret", string).andTemplate(Template.toolsPath());
    }

    @FilterWith(value={AdminFilter.class})
    public Response toolsRx(Request request) {
        Map<String, Object> map = request.getBodyAsJsonMap();
        Map<Object, Object> map2 = new HashMap();
        if (map != null && !map.isEmpty()) {
            String string = map.get("function").toString();
            if ("keypair".equalsIgnoreCase(string)) {
                KeyPair keyPair = this.crypto.generateKeyPair();
                String string2 = this.crypto.getKeyAsString(keyPair.getPublic());
                String string3 = this.crypto.getKeyAsString(keyPair.getPrivate());
                map2 = Map.of("publickey", string2, "privatekey", string3);
            } else if ("encrypt".equalsIgnoreCase(string)) {
                String string4 = map.get("cleartext").toString();
                String string5 = map.get("key").toString();
                try {
                    PublicKey publicKey = this.crypto.getPublicKeyFromString(string5);
                    map2 = Map.of("encrypted", this.crypto.encrypt(string4, publicKey));
                }
                catch (MangooEncryptionException mangooEncryptionException) {
                    LOG.error("Failed to encrypt cleartext.", (Throwable)mangooEncryptionException);
                }
            } else {
                LOG.warn("Invalid or no function selected for AJAX request.");
            }
        }
        return Response.withOk().andJsonBody(map2);
    }

    public Response login() {
        return Response.withOk().andTemplate(Template.loginPath());
    }

    public Response logout() {
        Cookie cookie = new CookieImpl("mangooio-admin").setValue("").setHttpOnly(true).setSecure(Application.inProdMode()).setPath("/").setDiscard(true).setExpires(new Date()).setSameSite(true).setSameSiteMode("Strict");
        return Response.withRedirect(ADMIN_INDEX).andCookie(cookie);
    }

    public Response authenticate(Form form) {
        form.expectValue("username");
        form.expectValue("password");
        if (AdminUtils.isNotLocked() && form.isValid()) {
            if (AdminUtils.isValidAuthentication(form)) {
                AdminUtils.resetLockCounter();
                return Response.withRedirect(ADMIN_INDEX).andCookie(AdminUtils.getAdminCookie(true));
            }
            AdminUtils.invalidAuthentication();
        }
        form.invalidate();
        form.keep();
        return Response.withRedirect("/@admin/login");
    }

    public Response verify(Form form) {
        form.expectValue("code");
        if (AdminUtils.isNotLocked() && form.isValid()) {
            if (TotpUtils.verifiedTotp(this.config.getApplicationAdminSecret(), form.get("code"))) {
                return Response.withRedirect(ADMIN_INDEX).andCookie(AdminUtils.getAdminCookie(false));
            }
            AdminUtils.invalidAuthentication();
        }
        form.invalidate();
        form.keep();
        return Response.withRedirect("/@admin/twofactor");
    }

    public Response twofactor() {
        return Response.withOk().andTemplate(Template.twofactorPath());
    }
}

