/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.admin;

import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.exceptions.MangooTokenException;
import io.mangoo.interfaces.filters.PerRequestFilter;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Request;
import io.mangoo.utils.MangooUtils;
import io.mangoo.utils.token.Token;
import io.mangoo.utils.token.TokenParser;
import io.undertow.server.handlers.Cookie;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;

public class AdminFilter
implements PerRequestFilter {
    private static final String VERSION_TAG = MangooUtils.getVersion();

    @Override
    public Response execute(Request request, Response response) {
        String string;
        Config config = Application.getInstance(Config.class);
        Cookie cookie = request.getCookie("mangooio-admin");
        if (cookie != null && StringUtils.isNotBlank((CharSequence)(string = cookie.getValue()))) {
            try {
                Token token = TokenParser.create().withSharedSecret(config.getApplicationSecret()).withCookieValue(string).parse();
                if (token.expirationIsAfter(LocalDateTime.now())) {
                    if (token.containsClaim("twofactor") && token.getClaim("twofactor", Boolean.class).booleanValue()) {
                        return Response.withRedirect("/@admin/twofactor").andEndResponse();
                    }
                    response.andContent("version", VERSION_TAG);
                    return response;
                }
            }
            catch (MangooTokenException mangooTokenException) {
                // empty catch block
            }
        }
        return Response.withRedirect("/@admin/login").andEndResponse();
    }
}

