/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.admin;

import io.mangoo.cache.Cache;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.exceptions.MangooTokenException;
import io.mangoo.routing.bindings.Form;
import io.mangoo.utils.MangooUtils;
import io.mangoo.utils.token.TokenBuilder;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AdminUtils {
    private static final Logger LOG = LogManager.getLogger(AdminUtils.class);
    private static final int ADMIN_LOGIN_MAX_RETRIES = 10;
    private static final String MANGOOIO_ADMIN_LOCKED_UNTIL = "mangooio-admin-locked-until";
    private static final String MANGOOIO_ADMIN_LOCK_COUNT = "mangooio-admin-lock-count";

    private AdminUtils() {
    }

    public static boolean isValidAuthentication(Form form) {
        String string;
        boolean bl = false;
        String string2 = Application.getInstance(Config.class).getApplicationAdminUsername();
        if (AdminUtils.checkAuthentication(form, string2, string = Application.getInstance(Config.class).getApplicationAdminPassword())) {
            bl = true;
        }
        return bl;
    }

    private static boolean checkAuthentication(Form form, String string, String string2) {
        return StringUtils.isNotBlank((CharSequence)string) && StringUtils.isNotBlank((CharSequence)string2) && string.equals(form.get("username")) && string2.equals(form.get("password"));
    }

    public static Cookie getAdminCookie(boolean bl) {
        TokenBuilder tokenBuilder = TokenBuilder.create().withSharedSecret(Application.getInstance(Config.class).getApplicationSecret()).withExpires(LocalDateTime.now().plusMinutes(30L)).withClaim("uuid", (Object)MangooUtils.randomString(32));
        if (bl && StringUtils.isNotBlank((CharSequence)Application.getInstance(Config.class).getApplicationAdminSecret())) {
            tokenBuilder.withClaim("twofactor", (Object)Boolean.TRUE);
        }
        String string = "";
        try {
            string = tokenBuilder.build();
        }
        catch (MangooTokenException mangooTokenException) {
            LOG.error("Failed to create admin cookie", (Throwable)mangooTokenException);
        }
        return new CookieImpl("mangooio-admin").setValue(string).setHttpOnly(true).setSecure(Application.inProdMode()).setPath("/").setSameSite(true).setSameSiteMode("Strict");
    }

    public static void invalidAuthentication() {
        AtomicInteger atomicInteger = Application.getInstance(Cache.class).getAndIncrementCounter(MANGOOIO_ADMIN_LOCK_COUNT);
        if (atomicInteger.intValue() >= 10) {
            Application.getInstance(Cache.class).put(MANGOOIO_ADMIN_LOCKED_UNTIL, LocalDateTime.now().plusMinutes(60L));
        }
        Application.getInstance(Cache.class).put(MANGOOIO_ADMIN_LOCK_COUNT, atomicInteger);
    }

    public static boolean isNotLocked() {
        LocalDateTime localDateTime = (LocalDateTime)Application.getInstance(Cache.class).get(MANGOOIO_ADMIN_LOCKED_UNTIL);
        return localDateTime == null || localDateTime.isBefore(LocalDateTime.now());
    }

    public static void resetLockCounter() {
        Application.getInstance(Cache.class).resetCounter(MANGOOIO_ADMIN_LOCK_COUNT);
    }
}

