/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.async;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Singleton;
import io.mangoo.async.Subscriber;
import io.mangoo.core.Application;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class EventBus<T> {
    private static final Logger LOG = LogManager.getLogger(EventBus.class);
    private final Multimap<String, Class<?>> subscribers = ArrayListMultimap.create();
    private final AtomicLong handledEvents = new AtomicLong();
    private final AtomicLong numSubscribers = new AtomicLong();

    public void register(String string, Class<?> clazz) {
        Objects.requireNonNull(string, "queue can not be null");
        Objects.requireNonNull(clazz, "subscriber can not be null");
        this.subscribers.put((Object)string, clazz);
        this.numSubscribers.addAndGet(1L);
    }

    public void publish(T t) {
        Objects.requireNonNull(t, "payload can not be null");
        Thread.ofVirtual().start(() -> {
            String string = t.getClass().getCanonicalName();
            try {
                for (Class clazz : this.subscribers.get((Object)string)) {
                    ((Subscriber)Application.getInstance(clazz)).receive(t);
                    this.handledEvents.addAndGet(1L);
                }
            }
            catch (Exception exception) {
                LOG.error("Failed to send payload to queue", (Throwable)exception);
            }
        });
    }

    public long getHandledEvents() {
        return this.handledEvents.longValue();
    }

    public long getNumberOfSubscribers() {
        return this.numSubscribers.longValue();
    }
}

