/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.cache;

import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.common.collect.Maps;
import io.mangoo.cache.Cache;
import java.time.LocalDateTime;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class CacheImpl
implements Cache {
    private static final String EXPIRES_SUFFIX = "-expires";
    private final com.github.benmanes.caffeine.cache.Cache<String, Object> caffeineCache;

    public CacheImpl(com.github.benmanes.caffeine.cache.Cache<String, Object> cache) {
        Objects.requireNonNull(cache, "cache can not be null");
        this.caffeineCache = cache;
    }

    @Override
    public void put(String string, Object object) {
        Objects.requireNonNull(string, "key can not be null");
        this.caffeineCache.put((Object)string, object);
    }

    @Override
    public void put(String string, Object object, int n, TemporalUnit temporalUnit) {
        Objects.requireNonNull(string, "key can not be null");
        Objects.requireNonNull(temporalUnit, "temporalunit can not be null");
        this.put(string, object, LocalDateTime.now().plus(n, temporalUnit));
    }

    @Override
    public void put(String string, Object object, LocalDateTime localDateTime) {
        Objects.requireNonNull(string, "key can not be null");
        Objects.requireNonNull(localDateTime, "expires can not be null");
        this.caffeineCache.put((Object)string, object);
        this.caffeineCache.put((Object)(string + EXPIRES_SUFFIX), (Object)localDateTime);
    }

    @Override
    public void remove(String string) {
        Objects.requireNonNull(string, "key can not be null");
        this.caffeineCache.invalidate((Object)string);
    }

    @Override
    public void clear() {
        this.caffeineCache.invalidateAll();
        this.caffeineCache.cleanUp();
    }

    @Override
    public <T> T get(String string) {
        Objects.requireNonNull(string, "key can not be null");
        Object object = this.caffeineCache.getIfPresent((Object)(string + EXPIRES_SUFFIX));
        if (object != null && LocalDateTime.now().isAfter((LocalDateTime)object)) {
            this.remove(string);
            this.remove(string + EXPIRES_SUFFIX);
        }
        return (T)this.caffeineCache.getIfPresent((Object)string);
    }

    @Override
    public <T> T get(String string, Function<String, Object> function) {
        Objects.requireNonNull(string, "key can not be null");
        Objects.requireNonNull(function, "fallback can not be null");
        Object object = this.caffeineCache.getIfPresent((Object)string);
        if (object == null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.computeIfAbsent(string, function);
            object = hashMap.get(string);
            this.caffeineCache.put((Object)string, object);
        }
        return (T)object;
    }

    @Override
    public Map<String, Object> getAll(String ... stringArray) {
        Objects.requireNonNull(stringArray, "key can not be null");
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)(stringArray.length + 1));
        for (String string : stringArray) {
            hashMap.put(string, this.get(string));
        }
        return hashMap;
    }

    @Override
    public void putAll(Map<String, Object> map) {
        Objects.requireNonNull(map, "map can not be null");
        this.caffeineCache.putAll(map);
    }

    @Override
    public AtomicInteger getAndIncrementCounter(String string) {
        Objects.requireNonNull(string, "key can not be null");
        AtomicInteger atomicInteger = (AtomicInteger)this.get(string);
        if (atomicInteger == null) {
            atomicInteger = new AtomicInteger(0);
        }
        atomicInteger.incrementAndGet();
        this.put(string, atomicInteger);
        return atomicInteger;
    }

    @Override
    public AtomicInteger getCounter(String string) {
        Objects.requireNonNull(string, "key can not be null");
        return (AtomicInteger)this.get(string);
    }

    @Override
    public AtomicInteger resetCounter(String string) {
        Objects.requireNonNull(string, "key can not be null");
        AtomicInteger atomicInteger = (AtomicInteger)this.get(string);
        if (atomicInteger == null) {
            atomicInteger = new AtomicInteger(0);
        }
        this.put(string, atomicInteger);
        return atomicInteger;
    }

    @Override
    public AtomicInteger getAndDecrementCounter(String string) {
        Objects.requireNonNull(string, "key can not be null");
        AtomicInteger atomicInteger = (AtomicInteger)this.get(string);
        if (atomicInteger == null) {
            atomicInteger = new AtomicInteger(0);
        }
        atomicInteger.decrementAndGet();
        this.put(string, atomicInteger);
        return atomicInteger;
    }

    public CacheStats getStats() {
        return this.caffeineCache.stats();
    }
}

