/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mangoo.cache.Cache;
import io.mangoo.cache.CacheImpl;
import io.mangoo.constants.CacheName;
import io.mangoo.core.Config;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Singleton
public class CacheProvider
implements Provider<Cache> {
    private final Map<String, Cache> caches = new HashMap<String, Cache>();
    private Cache cache;
    private static final long SIXTY = 60L;
    private static final long THIRTY = 30L;
    private static final long FORTY_THOUSAND = 40000L;

    @Inject
    @SuppressFBWarnings(value={"FII_USE_FUNCTION_IDENTITY"}, justification="Required by cache creation function")
    public CacheProvider(Config config) {
        Objects.requireNonNull(config, "config can not be null");
        this.initApplicationCache();
        this.initAuthenticationCache();
        this.setDefaultApplicationCache();
    }

    private void initApplicationCache() {
        CacheImpl cacheImpl = new CacheImpl((com.github.benmanes.caffeine.cache.Cache<String, Object>)Caffeine.newBuilder().maximumSize(40000L).expireAfterAccess(Duration.of(30L, ChronoUnit.DAYS)).recordStats().build());
        this.caches.put("mangooio-application-cache", cacheImpl);
    }

    private void initAuthenticationCache() {
        CacheImpl cacheImpl = new CacheImpl((com.github.benmanes.caffeine.cache.Cache<String, Object>)Caffeine.newBuilder().maximumSize(40000L).expireAfterAccess(Duration.of(60L, ChronoUnit.MINUTES)).recordStats().build());
        this.caches.put("mangooio-auth-cache", cacheImpl);
    }

    private void setDefaultApplicationCache() {
        this.cache = this.getCache("mangooio-application-cache");
    }

    public Cache getCache(CacheName cacheName) {
        return this.getCache(cacheName.toString());
    }

    public Cache getCache(String string) {
        return this.caches.get(string);
    }

    public Map<String, Cache> getCaches() {
        return this.caches;
    }

    public Cache get() {
        return this.cache;
    }
}

