/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.core;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Stage;
import com.mongodb.client.model.Indexes;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.FieldInfoList;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodParameterInfo;
import io.github.classgraph.ScanResult;
import io.mangoo.admin.AdminController;
import io.mangoo.async.EventBus;
import io.mangoo.async.Subscriber;
import io.mangoo.cache.CacheProvider;
import io.mangoo.core.Config;
import io.mangoo.core.Module;
import io.mangoo.core.Shutdown;
import io.mangoo.enums.Mode;
import io.mangoo.enums.Sort;
import io.mangoo.interfaces.MangooBootstrap;
import io.mangoo.persistence.interfaces.Datastore;
import io.mangoo.routing.Bind;
import io.mangoo.routing.On;
import io.mangoo.routing.Router;
import io.mangoo.routing.handlers.DispatcherHandler;
import io.mangoo.routing.handlers.ExceptionHandler;
import io.mangoo.routing.handlers.FallbackHandler;
import io.mangoo.routing.handlers.MetricsHandler;
import io.mangoo.routing.handlers.ServerSentEventHandler;
import io.mangoo.scheduler.CronTask;
import io.mangoo.scheduler.Schedule;
import io.mangoo.scheduler.Scheduler;
import io.mangoo.scheduler.Task;
import io.mangoo.utils.ByteUtils;
import io.mangoo.utils.MangooUtils;
import io.mangoo.utils.PersistenceUtils;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.sse.ServerSentEventConnectionCallback;
import io.undertow.util.Methods;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Application {
    private static final Logger LOG = LogManager.getLogger(Application.class);
    private static final LocalDateTime START = LocalDateTime.now();
    private static final int KEY_MIN_BIT_LENGTH = 512;
    private static final String COLLECTION = "io.mangoo.annotations.Collection";
    private static final String INDEXED = "io.mangoo.annotations.Indexed";
    private static final String SCHEDULER = "io.mangoo.annotations.Run";
    private static final String MODULE_CLASS = "app.Module";
    private static final String ALL_PACKAGES = "*";
    private static final String LOGO = "                                                ___     __  ___  \n _ __ ___    __ _  _ __    __ _   ___    ___   |_ _|   / / / _ \\ \n| '_ ` _ \\  / _` || '_ \\  / _` | / _ \\  / _ \\   | |   / / | | | |\n| | | | | || (_| || | | || (_| || (_) || (_) |  | |  / /  | |_| |\n|_| |_| |_| \\__,_||_| |_| \\__, | \\___/  \\___/  |___|/_/    \\___/ \n                          |___/                                  ";
    private static Module module;
    private static ScheduledExecutorService scheduledExecutorService;
    private static ExecutorService executorService;
    private static String httpHost;
    private static String ajpHost;
    private static Undertow undertow;
    private static Mode mode;
    private static Injector injector;
    private static PathHandler pathHandler;
    private static boolean started;
    private static int httpPort;
    private static int ajpPort;

    private Application() {
    }

    public static void main(String ... stringArray) {
        Application.start(Mode.PROD);
    }

    public static void start(Mode mode) {
        Objects.requireNonNull(mode, "mode can not be null");
        if (!started) {
            Application.userCheck();
            Application.prepareMode(mode);
            Application.prepareInjector();
            Application.applicationInitialized();
            Application.prepareConfig();
            Thread thread = Thread.ofVirtual().start(() -> {
                try (ScanResult scanResult = Application.scanClasspath();){
                    Application.prepareScheduler(scanResult);
                    Application.prepareDatastore(scanResult);
                    Application.prepareSubscriber(scanResult);
                }
            });
            Application.prepareRoutes();
            Application.createRoutes();
            Application.prepareUndertow();
            Application.prepareShutdown();
            Application.sanityChecks();
            while (thread.isAlive()) {
            }
            Application.applicationStarted();
            Application.showLogo();
            started = true;
        }
    }

    private static void prepareScheduler(ScanResult scanResult) {
        Config config = Application.getInstance(Config.class);
        if (config.isSchedulerEnabled()) {
            scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            executorService = Executors.newThreadPerTaskExecutor(Thread.ofPlatform().factory());
            scanResult.getClassesWithMethodAnnotation(SCHEDULER).forEach(classInfo -> classInfo.getMethodInfo().forEach(methodInfo -> {
                if (!methodInfo.getAnnotationInfo().isEmpty()) {
                    boolean bl = false;
                    long l = 0L;
                    String string = null;
                    for (int i = 0; i < methodInfo.getAnnotationInfo().size(); ++i) {
                        AnnotationInfo annotationInfo = (AnnotationInfo)methodInfo.getAnnotationInfo().get(i);
                        string = ((String)((AnnotationParameterValue)annotationInfo.getParameterValues(true).get("at")).getValue()).toLowerCase(Locale.ENGLISH).trim();
                        if (string.contains("every")) {
                            string = string.replace("every", "").trim();
                            String string2 = string.substring(0, string.length() - 1);
                            String string3 = string.substring(string.length() - 1);
                            l = Application.getSeconds(string2, string3);
                            continue;
                        }
                        bl = true;
                    }
                    if (StringUtils.isNotBlank(string)) {
                        Application.schedule(classInfo, methodInfo, bl, l, string);
                    }
                }
            }));
        }
    }

    private static long getSeconds(String string, String string2) {
        Objects.requireNonNull(string, "timespan can not be null");
        Objects.requireNonNull(string2, "duration can not be null");
        long l = Long.parseLong(string);
        return switch (string2) {
            case "m" -> l * 60L;
            case "h" -> l * 3600L;
            case "d" -> l * 86400L;
            default -> l;
        };
    }

    private static void schedule(ClassInfo classInfo, MethodInfo methodInfo, boolean bl, long l, String string) {
        Objects.requireNonNull(classInfo, "classInfo can not be null");
        Objects.requireNonNull(methodInfo, "methodInfo can not be null");
        Objects.requireNonNull(string, "at can not be null");
        try {
            Application.getInstance(classInfo.loadClass());
        }
        catch (Exception exception) {
            LOG.error("Failed to scheduled a task as class creation ran into an error. Check class '{}' with method '{}'", (Object)classInfo.getName(), (Object)methodInfo.getName(), (Object)exception);
            Application.failsafe();
        }
        if (bl) {
            try {
                CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX));
                Cron cron = cronParser.parse(string);
                cron.validate();
                CronTask cronTask = new CronTask(classInfo.loadClass(), methodInfo.getName(), string);
                ScheduledFuture<Future> scheduledFuture = scheduledExecutorService.schedule(() -> executorService.submit(cronTask), 0L, TimeUnit.SECONDS);
                Application.getInstance(Scheduler.class).addSchedule(Schedule.of(classInfo.loadClass().toString(), methodInfo.getName(), string, scheduledFuture, true));
                LOG.info("Successfully scheduled cron task from class '{}' with method '{}' and cron '{}'", (Object)classInfo.getName(), (Object)methodInfo.getName(), (Object)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.error("Scheduled cron task found, but the unix cron is invalid", (Throwable)illegalArgumentException);
                Application.failsafe();
            }
        } else if (l > 0L) {
            Task task = new Task(classInfo.loadClass(), methodInfo.getName());
            ScheduledFuture<?> scheduledFuture = scheduledExecutorService.scheduleWithFixedDelay(() -> executorService.submit(task), l, l, TimeUnit.SECONDS);
            Application.getInstance(Scheduler.class).addSchedule(Schedule.of(classInfo.loadClass().toString(), methodInfo.getName(), "every " + string, scheduledFuture, false));
            LOG.info("Successfully scheduled task from class '{}' with method '{}' at rate 'Every {}'", (Object)classInfo.getName(), (Object)methodInfo.getName(), (Object)string);
        } else {
            LOG.error("Scheduled task found, but unable to schedule it. Check class '{}' with method '{}' at rate 'Every {}'", (Object)classInfo.getName(), (Object)methodInfo.getName(), (Object)string);
            Application.failsafe();
        }
    }

    private static void prepareDatastore(ScanResult scanResult) {
        Config config = Application.getInstance(Config.class);
        if (config.isPersistenceEnabled()) {
            scanResult.getClassesWithAnnotation(COLLECTION).forEach(classInfo -> {
                String string = classInfo.getName();
                AnnotationInfoList annotationInfoList = classInfo.getAnnotationInfo();
                String string2 = (String)((AnnotationParameterValue)((AnnotationInfo)annotationInfoList.getFirst()).getParameterValues().getFirst()).getValue();
                PersistenceUtils.addCollection(string, string2);
            });
            scanResult.getClassesWithFieldAnnotation(INDEXED).forEach(classInfo -> {
                FieldInfoList fieldInfoList = classInfo.getFieldInfo();
                fieldInfoList.forEach(fieldInfo -> {
                    String string;
                    if (fieldInfo.getAnnotationInfo().size() == 1 && StringUtils.isNotBlank((CharSequence)(string = fieldInfo.getName())) && fieldInfo.getAnnotationInfo() != null) {
                        String string2 = ((AnnotationParameterValue)((AnnotationInfo)fieldInfo.getAnnotationInfo().getFirst()).getParameterValues().getFirst()).getValue().toString();
                        if (Sort.ASCENDING.value().equals(string2)) {
                            Application.getInstance(Datastore.class).addIndex(classInfo.loadClass(), Indexes.ascending((String[])new String[]{string}));
                        } else if (Sort.DESCENDING.value().equals(string2)) {
                            Application.getInstance(Datastore.class).addIndex(classInfo.loadClass(), Indexes.descending((String[])new String[]{string}));
                        }
                    }
                });
            });
        }
    }

    private static void prepareSubscriber(ScanResult scanResult) {
        scanResult.getClassesImplementing(Subscriber.class).forEach(classInfo -> {
            MethodInfo methodInfo = (MethodInfo)classInfo.getMethodInfo().getFirst();
            if ("receive".equals(methodInfo.getName())) {
                MethodParameterInfo methodParameterInfo = Arrays.asList(methodInfo.getParameterInfo()).getFirst();
                String string = methodParameterInfo.getTypeDescriptor().toString();
                Application.getInstance(EventBus.class).register(string, classInfo.loadClass());
            }
        });
    }

    private static void userCheck() {
        String string = System.getProperty("os.name");
        if (StringUtils.isNotBlank((CharSequence)string) && !string.startsWith("Windows")) {
            String[] stringArray = new String[]{"id", "-u"};
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
                String string2 = bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
                bufferedReader.close();
                if ("0".equals(string2) && Application.inProdMode()) {
                    LOG.error("Can not run application as root");
                    Application.failsafe();
                }
            }
            catch (IOException iOException) {
                LOG.error("Failed to check if application is started as root", (Throwable)iOException);
            }
        }
    }

    public static boolean inDevMode() {
        return Mode.DEV == mode;
    }

    public static boolean inProdMode() {
        return Mode.PROD == mode;
    }

    public static boolean inTestMode() {
        return Mode.TEST == mode;
    }

    public static Mode getMode() {
        return mode;
    }

    public static ScheduledExecutorService getScheduledExecutorService() {
        return scheduledExecutorService;
    }

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public static Injector getInjector() {
        return injector;
    }

    public static boolean isStarted() {
        return started;
    }

    public static LocalDateTime getStart() {
        return START;
    }

    public static Duration getUptime() {
        return Duration.between(START, LocalDateTime.now());
    }

    public static <T> T getInstance(Class<T> clazz) {
        Objects.requireNonNull(clazz, "class can not be null");
        return (T)injector.getInstance(clazz);
    }

    public static void stopUndertow() {
        undertow.stop();
    }

    private static void prepareMode(Mode mode) {
        String string = System.getProperty("application.mode");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            Application.mode = switch (string.toLowerCase(Locale.ENGLISH)) {
                case "dev" -> Mode.DEV;
                case "test" -> Mode.TEST;
                default -> Mode.PROD;
            };
        } else {
            Application.mode = mode;
        }
    }

    private static void prepareInjector() {
        injector = Guice.createInjector((Stage)Stage.PRODUCTION, Application.getModules());
    }

    private static void applicationInitialized() {
        Application.getInstance(MangooBootstrap.class).applicationInitialized();
    }

    private static void prepareConfig() {
        Config config = Application.getInstance(Config.class);
        int n = Application.getBitLength(config.getApplicationSecret());
        if (n < 512) {
            LOG.error("Application requires a 512 bit application secret. The current property for application.secret has currently only {} bit.", (Object)n);
            Application.failsafe();
        }
        if ((n = Application.getBitLength(config.getAuthenticationCookieSecret())) < 512) {
            LOG.error("Authentication cookie requires a 512 bit encryption key. The current property for authentication.cookie.secret has only {} bit.", (Object)n);
            Application.failsafe();
        }
        if ((n = Application.getBitLength(config.getAuthenticationCookieSecret())) < 512) {
            LOG.error("Authentication cookie requires a 512 bit sign key. The current property for authentication.cookie.signkey has only {} bit.", (Object)n);
            Application.failsafe();
        }
        if ((n = Application.getBitLength(config.getSessionCookieSecret())) < 512) {
            LOG.error("Session cookie secret a 512 bit encryption key. The current property for session.cookie.secret has only {} bit.", (Object)n);
            Application.failsafe();
        }
        if ((n = Application.getBitLength(config.getSessionCookieSecret())) < 512) {
            LOG.error("Session cookie requires a 512 bit sign key. The current property for session.cookie.signkey has only {} bit.", (Object)n);
            Application.failsafe();
        }
        if ((n = Application.getBitLength(config.getFlashCookieSecret())) < 512) {
            LOG.error("Flash cookie requires a 512 bit sign key. The current property for flash.cookie.signkey has only {} bit.", (Object)n);
            Application.failsafe();
        }
        if ((n = Application.getBitLength(config.getFlashCookieSecret())) < 512) {
            LOG.error("Flash cookie requires a 512 bit encryption key. The current property for flash.cookie.secret has only {} bit.", (Object)n);
            Application.failsafe();
        }
        if (!config.isDecrypted()) {
            LOG.error("Found encrypted config values in config.props but decryption was not successful!");
            Application.failsafe();
        }
    }

    private static void sanityChecks() {
        String string;
        Config config = Application.getInstance(Config.class);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!config.isAuthenticationCookieSecure()) {
            string = "Authentication cookie has secure flag set to 'false'. It is highly recommended to set authentication.cookie.secure to 'true' in an production environment.";
            arrayList.add(string);
            LOG.warn(string);
        }
        if ("mangooio-auth".equals(config.getAuthenticationCookieName())) {
            string = "Authentication cookie name has default value. Consider changing authentication.cookie.name to an application specific value.";
            arrayList.add(string);
            LOG.warn(string);
        }
        if (config.getAuthenticationCookieSecret().equals(config.getApplicationSecret())) {
            string = "Authentication cookie secret is using application secret. It is highly recommended to set a dedicated value to authentication.cookie.secret.";
            arrayList.add(string);
            LOG.warn(string);
        }
        if (!config.isSessionCookieSecure()) {
            string = "Session cookie has secure flag set to 'false'. It is highly recommended to set session.cookie.secure to 'true' in an production environment.";
            arrayList.add(string);
            LOG.warn(string);
        }
        if ("mangooio-session".equals(config.getSessionCookieName())) {
            string = "Session cookie name has default value. Consider changing session.cookie.name to an application specific value.";
            arrayList.add(string);
            LOG.warn(string);
        }
        if (config.getSessionCookieSecret().equals(config.getApplicationSecret())) {
            string = "Session cookie secret is using application secret. It is highly recommended to set a dedicated value to session.cookie.secret.";
            arrayList.add(string);
            LOG.warn(string);
        }
        if ("mangooio-flash".equals(config.getFlashCookieName())) {
            string = "Flash cookie name has default value. Consider changing flash.cookie.name to an application specific value.";
            arrayList.add(string);
            LOG.warn(string);
        }
        if (config.getFlashCookieSecret().equals(config.getApplicationSecret())) {
            string = "Flash cookie secret is using application secret. It is highly recommended to set a dedicated value to flash.cookie.secret.";
            arrayList.add(string);
            LOG.warn(string);
        }
        Application.getInstance(CacheProvider.class).getCache("mangooio-application-cache").put("MANGOOIO-WARNINGS", arrayList);
    }

    private static void prepareRoutes() {
        ((MangooBootstrap)injector.getInstance(MangooBootstrap.class)).initializeRoutes();
        Router.getRequestRoutes().forEach(requestRoute -> {
            if (!Application.methodExists(requestRoute.getControllerMethod(), requestRoute.getControllerClass())) {
                LOG.error("Could not find controller method '{}' in controller class '{}'", (Object)requestRoute.getControllerMethod(), requestRoute.getControllerClass());
                Application.failsafe();
            }
        });
    }

    private static boolean methodExists(String string, Class<?> clazz) {
        Objects.requireNonNull(string, "controller method can not be null");
        Objects.requireNonNull(clazz, "controller class can not be null");
        return Arrays.stream(clazz.getMethods()).anyMatch(method -> method.getName().equals(string));
    }

    private static void createRoutes() {
        pathHandler = new PathHandler((HttpHandler)Application.getRoutingHandler());
        Router.getServerSentEventRoutes().forEach(serverSentEventRoute -> pathHandler.addExactPath(serverSentEventRoute.getUrl(), (HttpHandler)Handlers.serverSentEvents((ServerSentEventConnectionCallback)Application.getInstance(ServerSentEventHandler.class).withAuthentication(serverSentEventRoute.hasAuthentication()))));
        Router.getPathRoutes().forEach(pathRoute -> pathHandler.addPrefixPath(pathRoute.getUrl(), (HttpHandler)new ResourceHandler((ResourceManager)new ClassPathResourceManager(Thread.currentThread().getContextClassLoader(), "files" + pathRoute.getUrl()))));
        pathHandler.addPrefixPath("/@admin/assets/", (HttpHandler)new ResourceHandler((ResourceManager)new ClassPathResourceManager(Thread.currentThread().getContextClassLoader(), "templates/@admin/assets/")));
    }

    private static RoutingHandler getRoutingHandler() {
        RoutingHandler routingHandler = Handlers.routing();
        routingHandler.setFallbackHandler((HttpHandler)Application.getInstance(FallbackHandler.class));
        Config config = Application.getInstance(Config.class);
        if (config.isApplicationAdminEnable()) {
            Bind.controller(AdminController.class).withRoutes(On.get().to("/@admin").respondeWith("index"), On.get().to("/@admin/cache").respondeWith("cache"), On.get().to("/@admin/login").respondeWith("login"), On.get().to("/@admin/twofactor").respondeWith("twofactor"), On.get().to("/@admin/scheduler").respondeWith("scheduler"), On.get().to("/@admin/tools").respondeWith("tools"), On.get().to("/@admin/logout").respondeWith("logout"), On.post().to("/@admin/authenticate").respondeWith("authenticate"), On.post().to("/@admin/verify").respondeWith("verify"), On.post().to("/@admin/tools").respondeWith("toolsRx"));
        }
        Router.getRequestRoutes().forEach(requestRoute -> {
            DispatcherHandler dispatcherHandler = Application.getInstance(DispatcherHandler.class).dispatch(requestRoute.getControllerClass(), requestRoute.getControllerMethod()).isBlocking(requestRoute.isBlocking()).withBasicAuthentication(requestRoute.getUsername(), requestRoute.getPassword()).withAuthentication(requestRoute.hasAuthentication());
            routingHandler.add(requestRoute.getMethod().toString(), requestRoute.getUrl(), (HttpHandler)dispatcherHandler);
        });
        ResourceHandler resourceHandler = Handlers.resource((ResourceManager)new ClassPathResourceManager(Thread.currentThread().getContextClassLoader(), "files/"));
        Router.getFileRoutes().forEach(fileRoute -> routingHandler.add(Methods.GET, fileRoute.getUrl(), (HttpHandler)resourceHandler));
        return routingHandler;
    }

    private static void prepareUndertow() {
        Config config = Application.getInstance(Config.class);
        Object object = config.isMetricsEnable() ? MetricsHandler.HANDLER_WRAPPER.wrap((HttpHandler)Handlers.exceptionHandler((HttpHandler)pathHandler).addExceptionHandler(Throwable.class, (HttpHandler)Application.getInstance(ExceptionHandler.class))) : Handlers.exceptionHandler((HttpHandler)pathHandler).addExceptionHandler(Throwable.class, (HttpHandler)Application.getInstance(ExceptionHandler.class));
        Undertow.Builder builder = Undertow.builder().setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)config.getUndertowMaxEntitySize()).setHandler((HttpHandler)object);
        httpHost = config.getConnectorHttpHost();
        httpPort = config.getConnectorHttpPort();
        ajpHost = config.getConnectorAjpHost();
        ajpPort = config.getConnectorAjpPort();
        boolean bl = false;
        if (httpPort > 0 && StringUtils.isNotBlank((CharSequence)httpHost)) {
            builder.addHttpListener(httpPort, httpHost);
            bl = true;
        }
        if (ajpPort > 0 && StringUtils.isNotBlank((CharSequence)ajpHost)) {
            builder.addAjpListener(ajpPort, ajpHost);
            bl = true;
        }
        if (bl) {
            undertow = builder.build();
            undertow.start();
        } else {
            LOG.error("No connector found! Please configure a HTTP and/or an AJP connector in your config.props file");
            Application.failsafe();
        }
    }

    @SuppressFBWarnings(justification="Buffer only used locally, without user input", value={"CRLF_INJECTION_LOGS"})
    private static void showLogo() {
        String string = "\n                                                ___     __  ___  \n _ __ ___    __ _  _ __    __ _   ___    ___   |_ _|   / / / _ \\ \n| '_ ` _ \\  / _` || '_ \\  / _` | / _ \\  / _ \\   | |   / / | | | |\n| | | | | || (_| || | | || (_| || (_) || (_) |  | |  / /  | |_| |\n|_| |_| |_| \\__,_||_| |_| \\__, | \\___/  \\___/  |___|/_/    \\___/ \n                          |___/                                  \n\nhttps://github.com/svenkubiak/mangooio | " + MangooUtils.getVersion() + "\n";
        LOG.info(string);
        if (httpPort > 0 && StringUtils.isNotBlank((CharSequence)httpHost)) {
            LOG.info("HTTP connector listening @{}:{}", (Object)httpHost, (Object)httpPort);
        }
        if (ajpPort > 0 && StringUtils.isNotBlank((CharSequence)ajpHost)) {
            LOG.info("AJP connector listening @{}:{}", (Object)ajpHost, (Object)ajpPort);
        }
        String string2 = "mangoo I/O application started in " + ChronoUnit.MILLIS.between(START, LocalDateTime.now()) + " ms in " + String.valueOf((Object)mode) + " mode. Enjoy.";
        LOG.info(string2);
    }

    private static int getBitLength(String string) {
        Objects.requireNonNull(string, "secret can not be null");
        return ByteUtils.bitLength(RegExUtils.replaceAll((String)string, (String)"[^\\x00-\\x7F]", (String)""));
    }

    private static List<com.google.inject.Module> getModules() {
        ArrayList<com.google.inject.Module> arrayList = new ArrayList<com.google.inject.Module>();
        try {
            module = new Module();
            arrayList.add((com.google.inject.Module)module);
            arrayList.add((com.google.inject.Module)((AbstractModule)Class.forName(MODULE_CLASS).getConstructor(new Class[0]).newInstance(new Object[0])));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            LOG.error("Failed to load modules. Check that app/Module.java exists in your application", (Throwable)exception);
            Application.failsafe();
        }
        return arrayList;
    }

    private static void applicationStarted() {
        Application.getInstance(MangooBootstrap.class).applicationStarted();
    }

    private static void failsafe() {
        System.out.print("Failed to start mangoo I/O application");
        System.exit(1);
    }

    private static void prepareShutdown() {
        Runtime.getRuntime().addShutdownHook(Application.getInstance(Shutdown.class));
    }

    private static ScanResult scanClasspath() {
        return new ClassGraph().enableAnnotationInfo().enableFieldInfo().enableClassInfo().enableMethodInfo().acceptPackages(new String[]{ALL_PACKAGES}).scan();
    }

    public static void stopEmbeddedMongoDB() {
        module.stopEmbeddedMongoDB();
    }
}

