/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.core;

import com.google.common.io.Resources;
import com.google.inject.Singleton;
import com.google.re2j.Pattern;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mangoo.constants.Default;
import io.mangoo.core.Application;
import io.mangoo.crypto.Crypto;
import io.mangoo.enums.Mode;
import io.mangoo.exceptions.MangooEncryptionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import jodd.props.Props;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class Config {
    private static final Logger LOG = LogManager.getLogger(Config.class);
    private static final String CONFIGURATION_FILE = "config.props";
    private static final String CRYPTEX_TAG = "cryptex{";
    private static final String ARG_TAG = "arg{}";
    private final Mode mode;
    private final Props props = Props.create();
    private Pattern corsUrl;
    private Pattern corsAllowOrigin;
    private boolean decrypted = true;

    public Config() {
        this.mode = Application.getMode();
        this.load();
    }

    public Config(Mode mode) {
        this.mode = Objects.requireNonNull(mode, "mode can not be null");
    }

    @SuppressFBWarnings(justification="Intentionally used to access the file system", value={"URLCONNECTION_SSRF_FD"})
    private void load() {
        Object object;
        this.props.setActiveProfiles(new String[]{this.mode.toString().toLowerCase(Locale.ENGLISH)});
        this.props.setSkipEmptyProps(false);
        String string = System.getProperty("application.config");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                this.props.load(new File(string));
            }
            catch (IOException iOException) {
                LOG.error("Failed to load config.props from {}", (Object)string, (Object)iOException);
            }
        } else {
            try {
                object = Resources.getResource((String)CONFIGURATION_FILE).openStream();
                try {
                    this.props.load((InputStream)object);
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            catch (IOException iOException) {
                LOG.error("Failed to load config.props from /src/main/resources/config.props", (Throwable)iOException);
            }
        }
        object = new HashMap();
        this.props.extractProps((Map)object, new String[]{Application.getMode().toString().toLowerCase(Locale.ENGLISH)});
        object.forEach(this::parse);
        System.setProperty("application.secret", "");
    }

    private void parse(String string, String string2) {
        if (ARG_TAG.equals(string2)) {
            String string3 = System.getProperty(string);
            if (StringUtils.isNotBlank((CharSequence)string3) && string3.startsWith(CRYPTEX_TAG)) {
                string3 = this.decrypt(string3);
            }
            if (StringUtils.isNotBlank((CharSequence)string3)) {
                this.props.setValue(string, string3, Application.getMode().toString().toLowerCase(Locale.ENGLISH));
            }
        }
        if (string2.startsWith(CRYPTEX_TAG)) {
            this.props.setValue(string, this.decrypt(string2), Application.getMode().toString().toLowerCase(Locale.ENGLISH));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String decrypt(String string) {
        Crypto crypto = new Crypto(this);
        String string2 = System.getProperty("application.privatekey");
        if (!StringUtils.isNotBlank((CharSequence)string2)) {
            LOG.error("Found an encrypted value in config file but private key for decryption is missing");
            this.decrypted = false;
            return "";
        }
        try (Stream<String> stream = Files.lines(Paths.get(string2, new String[0]));){
            String string4 = stream.findFirst().orElse(null);
            if (!StringUtils.isNotBlank((CharSequence)string4)) return "";
            PrivateKey privateKey = crypto.getPrivateKeyFromString(string4);
            String string5 = StringUtils.substringBetween((String)string, (String)CRYPTEX_TAG, (String)"}");
            if (privateKey != null && StringUtils.isNotBlank((CharSequence)string5)) {
                String string3 = crypto.decrypt(string5, privateKey);
                return string3;
            }
            LOG.error("Failed to decrypt an encrypted config value");
            this.decrypted = false;
            return "";
        }
        catch (MangooEncryptionException | IOException | SecurityException exception) {
            LOG.error("Failed to decrypt an encrypted config value", (Throwable)exception);
            this.decrypted = false;
            return "";
        }
    }

    public Properties toProperties() {
        HashMap hashMap = new HashMap();
        this.props.extractProps(hashMap);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)hashMap);
        return properties;
    }

    public boolean isDecrypted() {
        return this.decrypted;
    }

    public String getString(String string) {
        return this.props.getValue(string);
    }

    public String getString(String string, String string2) {
        return this.props.getValueOrDefault(string, string2);
    }

    public int getInt(String string) {
        String string2 = this.props.getValue(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return 0;
        }
        return Integer.parseInt(string2);
    }

    public long getLong(String string) {
        String string2 = this.props.getValue(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return 0L;
        }
        return Long.parseLong(string2);
    }

    public long getLong(String string, long l) {
        String string2 = this.props.getValue(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return l;
        }
        return Long.parseLong(string2);
    }

    public int getInt(String string, int n) {
        String string2 = this.props.getValue(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public Boolean getBoolean(String string) {
        String string2 = this.props.getValue(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(string2);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.props.getValue(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return bl;
        }
        return Boolean.parseBoolean(string2);
    }

    public Map<String, String> getAllConfigurations() {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        this.props.entries().forEach(propsEntry -> concurrentHashMap.put(propsEntry.getKey(), propsEntry.getValue()));
        return concurrentHashMap;
    }

    public String getApplicationName() {
        return this.getString("application.name");
    }

    public String getFlashCookieName() {
        return this.getString("flash.cookie.name", "mangooio-flash");
    }

    public String getSessionCookieName() {
        return this.getString("session.cookie.name", "mangooio-session");
    }

    public String getApplicationSecret() {
        return this.getString("application.secret");
    }

    public String getApplicationPublicKey() {
        return this.getString("application.publickey");
    }

    public String getAuthenticationCookieName() {
        return this.getString("authentication.cookie.name", "mangooio-auth");
    }

    public long getSessionCookieTokenExpires() {
        return this.getLong("session.cookie.token.expires", 60L);
    }

    public boolean isSessionCookieSecure() {
        return this.getBoolean("session.cookie.secure", Default.SESSION_COOKIE_SECURE);
    }

    public boolean isAuthenticationCookieSecure() {
        return this.getBoolean("authentication.cookie.secure", Default.AUTHENTICATION_COOKIE_SECURE);
    }

    public String getI18nCookieName() {
        return this.getString("i18n.cookie.name", "mangooio-i18n");
    }

    public boolean isFlashCookieSecure() {
        return this.isSessionCookieSecure();
    }

    public String getApplicationLanguage() {
        return this.getString("application.language", "en");
    }

    public String getApplicationAdminUsername() {
        return this.getString("application.admin.username");
    }

    public String getApplicationAdminPassword() {
        return this.getString("application.admin.password");
    }

    public long getAuthenticationCookieRememberExpires() {
        return this.getLong("authentication.cookie.remember.expires", 1209600L);
    }

    public String getApplicationController() {
        return this.getString("application.controller", "controllers.");
    }

    public boolean isApplicationAdminEnable() {
        return this.getBoolean("application.admin.enable", Default.APPLICATION_ADMIN_ENABLE);
    }

    public String getSmtpHost() {
        return this.getString("smtp.host", "localhost");
    }

    public int getSmtpPort() {
        return this.getInt("smtp.port", 25);
    }

    public String getSmtpUsername() {
        return this.getString("smtp.username", null);
    }

    public String getSmtpPassword() {
        return this.getString("smtp.password", null);
    }

    public String getSmtpFrom() {
        return this.getString("smtp.from", "mangoo <noreply@mangoo.local>");
    }

    public String getConnectorHttpHost() {
        return this.getString("connector.http.host", null);
    }

    public int getConnectorHttpPort() {
        return this.getInt("connector.http.port", 0);
    }

    public String getConnectorAjpHost() {
        return this.getString("connector.ajp.host", null);
    }

    public int getConnectorAjpPort() {
        return this.getInt("connector.ajp.port", 0);
    }

    public boolean isMetricsEnable() {
        return this.getBoolean("metrics.enable", Default.METRICS_ENABLE);
    }

    public int getAuthenticationLock() {
        return this.getInt("authentication.lock", 10);
    }

    public String getCacheClusterUrl() {
        return this.getString("cache.cluster.url", null);
    }

    public long getUndertowMaxEntitySize() {
        return this.getLong("undertow.maxentitysize", 0x400000L);
    }

    public String getSessionCookieSecret() {
        return this.getString("session.cookie.secret", this.getApplicationSecret());
    }

    public String getAuthenticationCookieSecret() {
        return this.getString("authentication.cookie.secret", this.getApplicationSecret());
    }

    public String getFlashCookieSecret() {
        return this.getString("flash.cookie.secret", this.getApplicationSecret());
    }

    public boolean isSchedulerEnabled() {
        return this.getBoolean("scheduler.enable", Default.SCHEDULER_ENABLE);
    }

    public String getApplicationAdminSecret() {
        return this.getString("application.admin.secret", null);
    }

    public boolean isSmtpDebug() {
        return this.getBoolean("smtp.debug", Default.SMTP_DEBUG);
    }

    public boolean isCorsEnable() {
        return this.getBoolean("cors.enable", Default.CORS_ENABLE);
    }

    public Pattern getCorsUrlPattern() {
        if (this.corsUrl == null) {
            this.corsUrl = Pattern.compile((String)this.getString("cors.urlpattern", "^http(s)?://([^/]+)(:([^/]+))?(/([^/])+)?/api(/.*)?$"));
        }
        return this.corsUrl;
    }

    public Pattern getCorsAllowOrigin() {
        if (this.corsAllowOrigin == null) {
            this.corsAllowOrigin = Pattern.compile((String)this.getString("cors.alloworigin", "^http(s)?://(www\\.)?example\\.(com|org)$"));
        }
        return this.corsAllowOrigin;
    }

    public String getCorsHeadersAllowCredentials() {
        return this.getString("cors.headers.allowcredentials", Default.CORS_HEADERS_ALLOW_CREDENTIALS.toString());
    }

    public String getCorsHeadersAllowHeaders() {
        return this.getString("cors.headers.allowheaders", "Authorization,Content-Type,Link,X-Total-Count,Range");
    }

    public String getCorsHeadersAllowMethods() {
        return this.getString("cors.headers.allowmethods", "DELETE,GET,HEAD,OPTIONS,PATCH,POST,PUT");
    }

    public String getCorsHeadersExposeHeaders() {
        return this.getString("cors.headers.exposeheaders", "Accept-Ranges,Content-Length,Content-Range,ETag,Link,Server,X-Total-Count");
    }

    public String getCorsHeadersMaxAge() {
        return this.getString("cors.headers.maxage", "864000");
    }

    public String getMongoHost(String string) {
        return this.getString(string + "mongo.host", "localhost");
    }

    public int getMongoPort(String string) {
        return this.getInt(string + "mongo.port", 27017);
    }

    public String getMongoUsername(String string) {
        return this.getString(string + "mongo.username", null);
    }

    public String getMongoPassword(String string) {
        return this.getString(string + "mongo.password", null);
    }

    public String getMongoAuthDB(String string) {
        return this.getString(string + "mongo.authdb", null);
    }

    public Boolean isMongoAuth(String string) {
        return this.getBoolean(string + "mongo.auth", Boolean.FALSE);
    }

    public String getMongoDbName(String string) {
        return this.getString(string + "mongo.dbname", "mangoo-io-mongodb");
    }

    public Boolean isMongoEmbedded(String string) {
        return this.getBoolean(string + "mongo.embedded", Boolean.FALSE);
    }

    public Boolean isSessionCookieExpires() {
        return this.getBoolean("session.cookie.expires", Boolean.FALSE);
    }

    public boolean isAuthenticationCookieExpires() {
        return this.getBoolean("authentication.cookie.expires", Default.AUTHENTICATION_COOKIE_EXPIRES);
    }

    public long getAuthenticationCookieTokenExpires() {
        return this.getLong("authentication.cookie.token.expires", 60L);
    }

    public boolean isSmtpAuthentication() {
        return this.getBoolean("smtp.authentication", Default.SMTP_AUTHENTICATION);
    }

    public boolean isPersistenceEnabled() {
        return this.getBoolean("persistence.enable", Default.PERSISTENCE_ENABLE);
    }

    public String getSmtpProtocol() {
        return this.getString("smtp.protocol", "smtps");
    }
}

