/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.core;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.name.Names;
import de.svenkubiak.embeddedmongodb.EmbeddedMongoDB;
import io.mangoo.cache.Cache;
import io.mangoo.cache.CacheProvider;
import io.mangoo.core.Config;
import io.mangoo.persistence.DatastoreProvider;
import io.mangoo.persistence.interfaces.Datastore;
import java.util.Properties;

public class Module
extends AbstractModule {
    private final Config config = new Config();
    private EmbeddedMongoDB embeddedMongoDB;

    public Module() {
        String string = "persistence.";
        if (this.config.isPersistenceEnabled() && Boolean.TRUE.equals(this.config.isMongoEmbedded(string))) {
            this.embeddedMongoDB = EmbeddedMongoDB.create().withHost(this.config.getMongoHost(string)).withPort(this.config.getMongoPort(string)).start();
        }
    }

    protected void configure() {
        Names.bindProperties((Binder)this.binder(), (Properties)this.config.toProperties());
        this.bind(Cache.class).toProvider(CacheProvider.class);
        this.bind(Datastore.class).toProvider(DatastoreProvider.class);
    }

    public void stopEmbeddedMongoDB() {
        if (this.embeddedMongoDB != null) {
            this.embeddedMongoDB.stop();
        }
    }
}

