/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.core;

import com.google.inject.Singleton;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.interfaces.MangooBootstrap;

@Singleton
public class Shutdown
extends Thread {
    @Override
    public void run() {
        Shutdown.invokeLifecycle();
        Shutdown.stopUndertow();
        Shutdown.stopScheduler();
        Shutdown.stopEmbeddedMongoDB();
    }

    private static void invokeLifecycle() {
        Application.getInstance(MangooBootstrap.class).applicationStopped();
    }

    private static void stopScheduler() {
        if (Application.getInstance(Config.class).isSchedulerEnabled()) {
            Application.getScheduledExecutorService().shutdown();
            Application.getExecutorService().shutdown();
        }
    }

    private static void stopUndertow() {
        Application.stopUndertow();
    }

    private static void stopEmbeddedMongoDB() {
        Application.stopEmbeddedMongoDB();
    }
}

