/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.email;

import com.google.common.base.Preconditions;
import io.mangoo.core.Application;
import io.mangoo.email.PostOffice;
import io.mangoo.exceptions.MangooTemplateEngineException;
import io.mangoo.templating.TemplateContext;
import io.mangoo.templating.TemplateEngine;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Mail {
    private static final int LOWEST_PRIORITY = 5;
    private static final int HIGHEST_PRIORITY = 1;
    private final Map<String, String> mailHeaders = new HashMap<String, String>();
    private final List<String> mailTos = new ArrayList<String>();
    private final List<String> mailCcs = new ArrayList<String>();
    private final List<String> mailBccs = new ArrayList<String>();
    private final List<Path> mailAttachments = new ArrayList<Path>();
    private String mailSubject;
    private String mailReplyTo;
    private String mailText;
    private String mailFromName;
    private String mailFromAddress;
    private boolean mailHtml;

    public static Mail newMail() {
        return new Mail();
    }

    public Mail to(String ... stringArray) {
        Objects.requireNonNull(stringArray, "tos can not be null");
        this.mailTos.addAll(Arrays.asList(stringArray));
        return this;
    }

    public Mail cc(String ... stringArray) {
        Objects.requireNonNull(stringArray, "ccs can not be null");
        this.mailCcs.addAll(Arrays.asList(stringArray));
        return this;
    }

    public Mail bcc(String ... stringArray) {
        Objects.requireNonNull(stringArray, "bccs can not be null");
        this.mailBccs.addAll(Arrays.asList(stringArray));
        return this;
    }

    public Mail subject(String string) {
        Objects.requireNonNull(string, "subject can not be null");
        this.mailSubject = string;
        return this;
    }

    public Mail from(String string, String string2) {
        Objects.requireNonNull(string, "from can not be null");
        Objects.requireNonNull(string2, "name can not be null");
        this.mailFromName = string;
        this.mailFromAddress = string2;
        return this;
    }

    public Mail from(String string) {
        Objects.requireNonNull(string, "from can not be null");
        this.mailFromAddress = string;
        return this;
    }

    public Mail header(String string, String string2) {
        Objects.requireNonNull(string, "name can not be null");
        Objects.requireNonNull(string2, "value can not be null");
        this.mailHeaders.put(string, string2);
        return this;
    }

    public Mail replyTo(String string) {
        Objects.requireNonNull(string, "replyTo can not be null");
        this.mailReplyTo = string;
        return this;
    }

    public Mail priority(int n) {
        Preconditions.checkArgument((n >= 1 && n <= 5 ? 1 : 0) != 0, (Object)"Priority of 1 through 5 are acceptable, with 1 being the highest priority, 3 = normal and 5 = lowest priority");
        this.mailHeaders.put("X-Priority", String.valueOf(n));
        return this;
    }

    public Mail attachment(Path path) {
        Objects.requireNonNull(path, "path can not be null");
        Preconditions.checkArgument((path.toFile().length() != 0L ? 1 : 0) != 0, (Object)"content can not be null");
        this.mailAttachments.add(path);
        return this;
    }

    public Mail attachments(List<Path> list) {
        Objects.requireNonNull(list, "path can not be null");
        list.forEach(path -> {
            Objects.requireNonNull(path, "path can not be null");
            Preconditions.checkArgument((path.toFile().length() != 0L ? 1 : 0) != 0, (Object)"path can not be null");
        });
        this.mailAttachments.addAll(list);
        return this;
    }

    public Mail textMessage(String string) {
        this.mailText = string;
        return this;
    }

    public Mail htmlMessage(String string) {
        this.mailText = string;
        this.mailHtml = true;
        return this;
    }

    public Mail textMessage(String string, Map<String, Object> map) throws MangooTemplateEngineException {
        Objects.requireNonNull(string, "template can not be null");
        this.mailText = this.render(string, map);
        return this;
    }

    public Mail htmlMessage(String string, Map<String, Object> map) throws MangooTemplateEngineException {
        Objects.requireNonNull(string, "template can not be null");
        this.mailText = this.render(string, map);
        this.mailHtml = true;
        return this;
    }

    public void send() {
        Thread.ofVirtual().start(() -> Application.getInstance(PostOffice.class).send(this));
    }

    private String render(String string, Map<String, Object> map) throws MangooTemplateEngineException {
        Objects.requireNonNull(string, "template can not be null");
        Objects.requireNonNull(string, "content can not be null");
        if (string.charAt(0) == '/' || string.startsWith("\\")) {
            string = string.substring(1, string.length());
        }
        TemplateContext templateContext = new TemplateContext(map).withTemplatePath(string);
        return Application.getInstance(TemplateEngine.class).renderTemplate(templateContext);
    }

    public Map<String, String> getMailHeaders() {
        return this.mailHeaders;
    }

    public List<String> getMailTos() {
        return this.mailTos;
    }

    public List<String> getMailCcs() {
        return this.mailCcs;
    }

    public List<String> getMailBccs() {
        return this.mailBccs;
    }

    public List<Path> getMailAttachments() {
        return this.mailAttachments;
    }

    public String getMailSubject() {
        return this.mailSubject;
    }

    public String getMailReplyTo() {
        return this.mailReplyTo;
    }

    public String getMailText() {
        return this.mailText;
    }

    public String getMailFromName() {
        return this.mailFromName;
    }

    public String getMailFromAddress() {
        return this.mailFromAddress;
    }

    public boolean isMailHtml() {
        return this.mailHtml;
    }

    public boolean hasAttachments() {
        return !this.mailAttachments.isEmpty();
    }
}

