/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.email;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.mangoo.core.Config;
import io.mangoo.email.Mail;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class PostOffice {
    private static final Logger LOG = LogManager.getLogger(PostOffice.class);
    private final Session session;

    @Inject
    public PostOffice(final Config config) {
        Objects.requireNonNull(config, "config can not be null");
        Properties properties = new Properties();
        properties.put("mail.smtp.host", config.getSmtpHost());
        properties.put("mail.smtp.port", String.valueOf(config.getSmtpPort()));
        properties.put("mail.from", config.getSmtpFrom());
        properties.put("mail.debug", String.valueOf(config.isSmtpDebug()));
        if ("smtps".equalsIgnoreCase(config.getSmtpProtocol())) {
            properties.put("mail.smtp.ssl.enable", "true");
        } else if ("smtptls".equalsIgnoreCase(config.getSmtpProtocol())) {
            properties.put("mail.smtp.starttls.enable", "true");
        }
        Authenticator authenticator = null;
        if (config.isSmtpAuthentication()) {
            properties.put("mail.smtp.auth", "true");
            authenticator = new Authenticator(this){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(config.getSmtpUsername(), config.getSmtpPassword());
                }
            };
        } else {
            properties.put("mail.smtp.auth", "false");
        }
        this.session = Session.getInstance((Properties)properties, authenticator);
    }

    public void send(Mail mail) {
        Objects.requireNonNull(mail, "mail can not be null");
        try {
            MimeMessage mimeMessage = new MimeMessage(this.session);
            mimeMessage.setSentDate(new Date());
            mimeMessage.setSubject(mail.getMailSubject());
            this.setReplyTo(mail, mimeMessage);
            this.setHeaders(mail, mimeMessage);
            this.setRecipients(mail, mimeMessage);
            this.setCcs(mail, mimeMessage);
            this.setBccs(mail, mimeMessage);
            this.setFrom(mail, mimeMessage);
            this.setContent(mail, (Part)mimeMessage);
            this.setAttachments(mail, (Part)mimeMessage);
            Transport.send((Message)mimeMessage);
        }
        catch (MessagingException | IOException throwable) {
            LOG.error("Failed to send mail", throwable);
        }
    }

    private void setAttachments(Mail mail, Part part) throws MessagingException, IOException {
        Objects.requireNonNull(mail, "mail can not be null");
        Objects.requireNonNull(part, "part can not be null");
        if (mail.hasAttachments()) {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(mail.getMailText());
            MimeMultipart mimeMultipart = new MimeMultipart();
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            for (Path path : mail.getMailAttachments()) {
                mimeBodyPart = new MimeBodyPart();
                String string = path.toRealPath(new LinkOption[0]).toString();
                FileDataSource fileDataSource = new FileDataSource(string);
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
                mimeBodyPart.setFileName(string);
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            }
            part.setContent((Multipart)mimeMultipart);
        }
    }

    private void setContent(Mail mail, Part part) throws MessagingException {
        Objects.requireNonNull(mail, "mail can not be null");
        Objects.requireNonNull(part, "part can not be null");
        if (mail.isMailHtml()) {
            part.setContent((Object)mail.getMailText(), "text/html; charset=utf-8");
        } else {
            part.setText(mail.getMailText());
        }
    }

    private void setFrom(Mail mail, MimeMessage mimeMessage) throws MessagingException, UnsupportedEncodingException {
        Objects.requireNonNull(mail, "mail can not be null");
        Objects.requireNonNull(mimeMessage, "mimeMessage can not be null");
        String string = mail.getMailFromName();
        String string2 = mail.getMailFromAddress();
        if (StringUtils.isNotBlank((CharSequence)string) && StringUtils.isNotBlank((CharSequence)string2)) {
            mimeMessage.setFrom((Address)new InternetAddress(string2, string));
        } else {
            mimeMessage.setFrom((Address)new InternetAddress(string2));
        }
    }

    private void setBccs(Mail mail, MimeMessage mimeMessage) throws MessagingException {
        for (String string : mail.getMailBccs()) {
            mimeMessage.addRecipients(Message.RecipientType.BCC, string);
        }
    }

    private void setCcs(Mail mail, MimeMessage mimeMessage) throws MessagingException {
        for (String string : mail.getMailCcs()) {
            mimeMessage.addRecipients(Message.RecipientType.CC, string);
        }
    }

    private void setRecipients(Mail mail, MimeMessage mimeMessage) throws MessagingException {
        for (String string : mail.getMailTos()) {
            mimeMessage.addRecipients(Message.RecipientType.TO, string);
        }
    }

    private void setHeaders(Mail mail, MimeMessage mimeMessage) throws MessagingException {
        for (Map.Entry<String, String> entry : mail.getMailHeaders().entrySet()) {
            mimeMessage.addHeader(entry.getKey(), entry.getValue());
        }
    }

    private void setReplyTo(Mail mail, MimeMessage mimeMessage) throws MessagingException {
        String string = mail.getMailReplyTo();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            InternetAddress[] internetAddressArray = new InternetAddress[]{new InternetAddress(string)};
            mimeMessage.setReplyTo((Address[])internetAddressArray);
        }
    }
}

