/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.i18n;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mangoo.constants.Default;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class Messages
implements Serializable {
    private static final long serialVersionUID = -1713264225655435037L;
    private Map<String, String> defaults = Default.getMessages();
    private transient ResourceBundle bundle = ResourceBundle.getBundle("translations/messages", Locale.getDefault());

    public void reload(Locale locale) {
        this.bundle = ResourceBundle.getBundle("translations/messages", locale);
    }

    public String get(String string) {
        return this.bundle.getString(string);
    }

    @SuppressFBWarnings(justification="Key access as intended", value={"MUI_CONTAINSKEY_BEFORE_GET"})
    public String get(String string, Object ... objectArray) {
        if (this.bundle.containsKey(string)) {
            return MessageFormat.format(this.bundle.getString(string), objectArray);
        }
        if (this.defaults.containsKey(string)) {
            return MessageFormat.format(this.defaults.get(string), objectArray);
        }
        return "";
    }
}

