/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.manager;

import com.google.inject.Singleton;
import io.undertow.server.handlers.sse.ServerSentEventConnection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class ServerSentEventManager {
    private static final Map<String, ServerSentEventConnection> CONNECTIONS = new ConcurrentHashMap<String, ServerSentEventConnection>(16, 0.9f, 1);

    public void addConnection(String string, ServerSentEventConnection serverSentEventConnection) {
        Objects.requireNonNull(string, "uri can not be null");
        Objects.requireNonNull(serverSentEventConnection, "connection can not be null");
        CONNECTIONS.put(string, serverSentEventConnection);
    }

    public void removeConnection(String string) {
        Objects.requireNonNull(string, "uri can not be null");
        CONNECTIONS.remove(string);
    }

    public void send(String string, String string2) {
        Objects.requireNonNull(string, "uri can not be null");
        Thread.ofVirtual().start(() -> {
            ServerSentEventConnection serverSentEventConnection = CONNECTIONS.get(string);
            if (serverSentEventConnection != null && serverSentEventConnection.isOpen()) {
                serverSentEventConnection.send(string2);
            }
        });
    }
}

