/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.models;

import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.LongAdder;

@Singleton
public class Metrics {
    private static final int CONCURRENCY_LEVEL = 1;
    private static final float LOAD_FACTOR = 0.9f;
    private static final int INITIAL_CAPACITY = 16;
    private AtomicIntegerFieldUpdater<Metrics> maxRequestTimeUpdater = AtomicIntegerFieldUpdater.newUpdater(Metrics.class, "maxRequestTime");
    private AtomicIntegerFieldUpdater<Metrics> minRequestTimeUpdater = AtomicIntegerFieldUpdater.newUpdater(Metrics.class, "minRequestTime");
    private AtomicLongFieldUpdater<Metrics> totalRequestTimeUpdater = AtomicLongFieldUpdater.newUpdater(Metrics.class, "totalRequestTime");
    private AtomicLongFieldUpdater<Metrics> totalRequestsUpdater = AtomicLongFieldUpdater.newUpdater(Metrics.class, "totalRequests");
    private Map<Integer, LongAdder> responseCount = new ConcurrentHashMap<Integer, LongAdder>(16, 0.9f, 1);
    private AtomicLong dataSend = new AtomicLong();
    private volatile long avgRequestTime;
    private volatile long totalRequestTime;
    private volatile long totalRequests;
    private volatile int maxRequestTime = -1;
    private volatile int minRequestTime = -1;

    public Metrics() {
    }

    public Metrics(Metrics metrics) {
        this.totalRequestTime = metrics.totalRequestTime;
        this.maxRequestTime = metrics.maxRequestTime;
        this.minRequestTime = metrics.minRequestTime;
        this.totalRequests = metrics.totalRequests;
    }

    public void addStatusCode(int n2) {
        this.responseCount.computeIfAbsent(n2, n -> new LongAdder()).increment();
    }

    public void update(int n) {
        int n2;
        this.totalRequestTimeUpdater.addAndGet(this, n);
        while (n >= (n2 = this.maxRequestTime) && !this.maxRequestTimeUpdater.compareAndSet(this, n2, n)) {
        }
        if (n > 0) {
            int n3;
            while (!(n > (n3 = this.minRequestTime) && n3 != -1 || this.minRequestTimeUpdater.compareAndSet(this, n3, n))) {
            }
        }
        this.totalRequestsUpdater.incrementAndGet(this);
        this.avgRequestTime = this.totalRequestTime / this.totalRequests;
    }

    public Map<Integer, LongAdder> getResponseMetrics() {
        return this.responseCount;
    }

    public int getMaxRequestTime() {
        return this.maxRequestTime;
    }

    public int getMinRequestTime() {
        return this.minRequestTime;
    }

    public long getAvgRequestTime() {
        return this.avgRequestTime;
    }

    public void incrementDataSend(long l) {
        this.dataSend.addAndGet(l);
    }

    public long getDataSend() {
        return this.dataSend.longValue();
    }

    public void reset() {
        this.maxRequestTimeUpdater = AtomicIntegerFieldUpdater.newUpdater(Metrics.class, "maxRequestTime");
        this.minRequestTimeUpdater = AtomicIntegerFieldUpdater.newUpdater(Metrics.class, "minRequestTime");
        this.totalRequestTimeUpdater = AtomicLongFieldUpdater.newUpdater(Metrics.class, "totalRequestTime");
        this.totalRequestsUpdater = AtomicLongFieldUpdater.newUpdater(Metrics.class, "totalRequests");
        this.responseCount = new ConcurrentHashMap<Integer, LongAdder>(16, 0.9f, 1);
        this.dataSend = new AtomicLong();
        this.avgRequestTime = 0L;
        this.totalRequestTime = 0L;
        this.totalRequests = 0L;
        this.maxRequestTime = -1;
        this.minRequestTime = -1;
    }
}

