/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.persistence;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertOneResult;
import io.mangoo.core.Config;
import io.mangoo.persistence.interfaces.BaseEntity;
import io.mangoo.persistence.interfaces.Datastore;
import io.mangoo.utils.PersistenceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.Conventions;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class DatastoreImpl
implements Datastore {
    private static final Logger LOG = LogManager.getLogger(DatastoreImpl.class);
    private final Config config;
    private MongoDatabase mongoDatabase;
    private String prefix = "persistence.";

    @Inject
    public DatastoreImpl(Config config) {
        this.config = Objects.requireNonNull(config, "config can not be null");
        this.connect();
    }

    public DatastoreImpl(String string) {
        this.config = new Config();
        this.prefix = Objects.requireNonNull(string, "prefix can not be null");
        this.prefix = "persistence." + string + ".";
        this.connect();
    }

    private void connect() {
        if (this.config.isPersistenceEnabled()) {
            CodecRegistry codecRegistry = MongoClientSettings.getDefaultCodecRegistry();
            PojoCodecProvider pojoCodecProvider = PojoCodecProvider.builder().conventions(List.of(Conventions.ANNOTATION_CONVENTION)).automatic(true).build();
            MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(this.getConnectionString())).codecRegistry(CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{codecRegistry, CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{pojoCodecProvider})})).build();
            this.mongoDatabase = MongoClients.create((MongoClientSettings)mongoClientSettings).getDatabase(this.config.getMongoDbName(this.prefix));
            LOG.info("Created MongoClient connected to {}:{} with credentials = {} on database '{}'", (Object)this.config.getMongoHost(this.prefix), (Object)this.config.getMongoPort(this.prefix), (Object)this.config.isMongoAuth(this.prefix), (Object)this.config.getMongoDbName(this.prefix));
        }
    }

    private String getConnectionString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mongodb://");
        if (Boolean.TRUE.equals(this.config.isMongoAuth(this.prefix))) {
            stringBuilder.append(this.config.getMongoUsername(this.prefix)).append(':').append(this.config.getMongoPassword(this.prefix)).append('@');
        }
        stringBuilder.append(this.config.getMongoHost(this.prefix)).append(':').append(this.config.getMongoPort(this.prefix));
        if (Boolean.TRUE.equals(this.config.isMongoAuth(this.prefix))) {
            stringBuilder.append("/?authSource=").append(this.config.getMongoAuthDB(this.prefix));
        }
        return stringBuilder.toString();
    }

    @Override
    public <T> T find(Class<T> clazz, Bson bson) {
        Objects.requireNonNull(clazz, "class can not be null");
        Objects.requireNonNull(bson, "key can not be null");
        return (T)this.query(clazz).find(bson).first();
    }

    @Override
    public <T> T findFirst(Class<T> clazz, Bson bson) {
        Objects.requireNonNull(clazz, "class can not be null");
        Objects.requireNonNull(bson, "sort can not be null");
        return (T)this.query(clazz).find().sort(bson).first();
    }

    @Override
    public <T> List<T> findAll(Class<T> clazz, Bson bson, Bson bson2) {
        Objects.requireNonNull(clazz, "class can not be null");
        Objects.requireNonNull(bson, "key can not be null");
        Objects.requireNonNull(bson2, "sort can not be null");
        ArrayList arrayList = new ArrayList();
        MongoCollection mongoCollection = this.getCollection(clazz).orElseGet(null);
        if (mongoCollection != null) {
            mongoCollection.find(bson).sort(bson2).forEach(arrayList::add);
        }
        return arrayList;
    }

    @Override
    public <T> List<T> findAll(Class<T> clazz, Bson bson, Bson bson2, int n) {
        Objects.requireNonNull(clazz, "class can not be null");
        Objects.requireNonNull(bson, "key can not be null");
        Objects.requireNonNull(bson2, "sort can not be null");
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"limit must be greater than 0");
        ArrayList arrayList = new ArrayList();
        MongoCollection mongoCollection = this.getCollection(clazz).orElseGet(null);
        if (mongoCollection != null) {
            mongoCollection.find(bson).sort(bson2).limit(n).forEach(arrayList::add);
        }
        return arrayList;
    }

    @Override
    public <T> List<T> findAll(Class<T> clazz) {
        Objects.requireNonNull(clazz, "class can not be null");
        ArrayList arrayList = new ArrayList();
        MongoCollection mongoCollection = this.getCollection(clazz).orElseGet(null);
        if (mongoCollection != null) {
            mongoCollection.find().forEach(arrayList::add);
        }
        return arrayList;
    }

    @Override
    public <T> List<T> findAll(Class<T> clazz, Bson bson) {
        Objects.requireNonNull(clazz, "class can not be null");
        Objects.requireNonNull(bson, "sort can not be null");
        ArrayList arrayList = new ArrayList();
        MongoCollection mongoCollection = this.getCollection(clazz).orElseGet(null);
        if (mongoCollection != null) {
            mongoCollection.find().sort(bson).forEach(arrayList::add);
        }
        return arrayList;
    }

    @Override
    public <T> long countAll(Class<T> clazz, Bson bson) {
        Objects.requireNonNull(clazz, "class can not be null");
        Objects.requireNonNull(clazz, "query can not be null");
        long l = -1L;
        MongoCollection mongoCollection = this.getCollection(clazz).orElseGet(null);
        if (mongoCollection != null) {
            l = mongoCollection.countDocuments(bson);
        }
        return l;
    }

    @Override
    public <T> long countAll(Class<T> clazz) {
        Objects.requireNonNull(clazz, "class can not be null");
        long l = -1L;
        MongoCollection mongoCollection = this.getCollection(clazz).orElseGet(null);
        if (mongoCollection != null) {
            l = mongoCollection.countDocuments();
        }
        return l;
    }

    @Override
    public String save(Object object) {
        Objects.requireNonNull(object, "object can not be null");
        MongoCollection mongoCollection = this.getCollection(object.getClass()).orElse(null);
        if (mongoCollection != null) {
            BaseEntity baseEntity = (BaseEntity)object;
            ObjectId objectId = baseEntity.getId();
            if (objectId == null) {
                InsertOneResult insertOneResult = mongoCollection.insertOne(object);
                if (insertOneResult.getInsertedId() != null) {
                    return insertOneResult.getInsertedId().asObjectId().getValue().toString();
                }
            } else {
                mongoCollection.replaceOne(Filters.eq((String)"_id", (Object)objectId), object);
                return objectId.toString();
            }
        }
        return "";
    }

    @Override
    public <T> void saveAll(List<T> list) {
        Objects.requireNonNull(list, "objects can not be null");
        list.forEach(this::save);
    }

    @Override
    public <T> MongoCollection query(Class<T> clazz) {
        Objects.requireNonNull(clazz, "class can not be null");
        return this.getCollection(clazz).orElse(null);
    }

    @Override
    public MongoCollection query(String string) {
        Objects.requireNonNull(string, "collection can not be null");
        return this.mongoDatabase.getCollection(string);
    }

    @Override
    public DeleteResult delete(Object object) {
        Objects.requireNonNull(object, "object can not be null");
        BaseEntity baseEntity = (BaseEntity)object;
        return this.query(object.getClass()).deleteOne(Filters.eq((String)"_id", (Object)baseEntity.getId()));
    }

    @Override
    public void deleteAll(List<Object> list) {
        Objects.requireNonNull(list, "objects can not be null");
        list.forEach(this::delete);
    }

    @Override
    public void dropDatabase() {
        this.mongoDatabase.drop();
    }

    @Override
    public <T> void dropCollection(Class<T> clazz) {
        Objects.requireNonNull(clazz, "class can not be null");
        this.getCollection(clazz).ifPresent(MongoCollection::drop);
    }

    @Override
    public <T> void addIndex(Class<T> clazz, Bson ... bsonArray) {
        Objects.requireNonNull(clazz, "class can not be null");
        Objects.requireNonNull(bsonArray, "indexes van not be null");
        this.getCollection(clazz).ifPresent(mongoCollection -> Stream.of(bsonArray).forEach(arg_0 -> ((MongoCollection)mongoCollection).createIndex(arg_0)));
    }

    @Override
    public <T> void addIndex(Class<T> clazz, Bson bson, IndexOptions indexOptions) {
        Objects.requireNonNull(clazz, "class can not be null");
        Objects.requireNonNull(bson, "index can not be null");
        Objects.requireNonNull(indexOptions, "indexOptions can not be null");
        this.getCollection(clazz).ifPresent(mongoCollection -> mongoCollection.createIndex(bson, indexOptions));
    }

    @Override
    public <T> void dropIndex(Class<T> clazz, Bson ... bsonArray) {
        Objects.requireNonNull(clazz, "class can not be null");
        Objects.requireNonNull(bsonArray, "indexes van not be null");
        this.getCollection(clazz).ifPresent(mongoCollection -> Stream.of(bsonArray).forEach(arg_0 -> ((MongoCollection)mongoCollection).dropIndex(arg_0)));
    }

    private <T> Optional<MongoCollection> getCollection(Class<T> clazz) {
        Objects.requireNonNull(clazz, "class can not be null");
        MongoCollection mongoCollection = null;
        String string = PersistenceUtils.getCollectionName(clazz);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            mongoCollection = this.mongoDatabase.getCollection(string, clazz);
        }
        return Optional.ofNullable(mongoCollection);
    }
}

