/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.persistence;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.mangoo.persistence.DatastoreImpl;
import io.mangoo.persistence.interfaces.Datastore;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Singleton
public class DatastoreProvider
implements Provider<Datastore> {
    private final Map<String, DatastoreImpl> datastores = new HashMap<String, DatastoreImpl>();
    private final DatastoreImpl defaultDatastore;

    @Inject
    private DatastoreProvider(DatastoreImpl datastoreImpl) {
        this.defaultDatastore = Objects.requireNonNull(datastoreImpl, "datastore can not be null");
    }

    public Datastore getDatastore(String string) {
        Objects.requireNonNull(string, "prefix can not be null");
        return this.datastores.computeIfAbsent(string, string2 -> new DatastoreImpl(string));
    }

    public Datastore get() {
        return this.defaultDatastore;
    }
}

