/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing;

import io.mangoo.i18n.Messages;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Authentication;
import io.mangoo.routing.bindings.Flash;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.bindings.Request;
import io.mangoo.routing.bindings.Session;
import io.mangoo.templating.TemplateEngine;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class Attachment {
    private Authentication authentication;
    private String controllerClassName;
    private String controllerMethodName;
    private String body;
    private String username;
    private String password;
    private List<Annotation> classAnnotations;
    private Class<?> controllerClass;
    private Object controllerInstance;
    private Flash flash;
    private Form form;
    private Locale locale;
    private Messages messages;
    private Method method;
    private List<Annotation> methodAnnotations;
    private Map<String, Class<?>> methodParameters;
    private Request request;
    private Map<String, String> requestParameter;
    private Response response;
    private Session session;
    private TemplateEngine templateEngine;
    private int limit;
    private int methodParametersCount;
    private boolean requestFilter;
    private boolean requiresAuthentication;

    public static Attachment build() {
        return new Attachment();
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public String getBody() {
        return this.body;
    }

    public List<Annotation> getClassAnnotations() {
        return new ArrayList<Annotation>(this.classAnnotations);
    }

    public String getControllerAndMethod() {
        return this.controllerClassName + ":" + this.controllerMethodName;
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public String getControllerClassName() {
        return this.controllerClassName;
    }

    public Object getControllerInstance() {
        return this.controllerInstance;
    }

    public String getControllerMethodName() {
        return this.controllerMethodName;
    }

    public Flash getFlash() {
        return this.flash;
    }

    public Form getForm() {
        return this.form;
    }

    public int getLimit() {
        return this.limit;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public Method getMethod() {
        return this.method;
    }

    public List<Annotation> getMethodAnnotations() {
        return new ArrayList<Annotation>(this.methodAnnotations);
    }

    public Map<String, Class<?>> getMethodParameters() {
        return this.methodParameters;
    }

    public int getMethodParametersCount() {
        return this.methodParametersCount;
    }

    public String getPassword() {
        return this.password;
    }

    public Request getRequest() {
        return this.request;
    }

    public Map<String, String> getRequestParameter() {
        return this.requestParameter;
    }

    public Response getResponse() {
        return this.response;
    }

    public Session getSession() {
        return this.session;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean hasAuthentication() {
        return this.requiresAuthentication;
    }

    public boolean hasRequestFilter() {
        return this.requestFilter;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public void setFlash(Flash flash) {
        this.flash = flash;
    }

    public void setForm(Form form) {
        this.form = form;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Attachment withClassAnnotations(Collection<Annotation> collection) {
        this.classAnnotations = new ArrayList<Annotation>(collection);
        return this;
    }

    public Attachment withControllerClass(Class<?> clazz) {
        this.controllerClass = Objects.requireNonNull(clazz, "controller class can not be null");
        return this;
    }

    public Attachment withControllerClassName(String string) {
        this.controllerClassName = Objects.requireNonNull(string, "controller name can not be null");
        return this;
    }

    public Attachment withControllerInstance(Object object) {
        this.controllerInstance = Objects.requireNonNull(object, "controller instance can not be null");
        return this;
    }

    public Attachment withControllerMethodName(String string) {
        this.controllerMethodName = Objects.requireNonNull(string, "controller method can not be null");
        return this;
    }

    public Attachment withLimit(int n) {
        this.limit = n;
        return this;
    }

    public Attachment withLocale(Locale locale) {
        this.locale = Objects.requireNonNull(locale, "locale can not be null");
        return this;
    }

    public Attachment withMessages(Messages messages) {
        this.messages = Objects.requireNonNull(messages, "messages can not be null");
        return this;
    }

    public Attachment withMethod(Method method) {
        this.method = Objects.requireNonNull(method, "method can not be null");
        return this;
    }

    public Attachment withMethodAnnotations(Collection<Annotation> collection) {
        this.methodAnnotations = new ArrayList<Annotation>(collection);
        return this;
    }

    public Attachment withMethodParameterCount(int n) {
        this.methodParametersCount = n;
        return this;
    }

    public Attachment withMethodParameters(Map<String, Class<?>> map) {
        this.methodParameters = Objects.requireNonNull(map, "method parameters can not be null");
        return this;
    }

    public Attachment withBasicAuthentication(String string, String string2) {
        this.username = string;
        this.password = string2;
        return this;
    }

    public Attachment withRequestFilter(boolean bl) {
        this.requestFilter = bl;
        return this;
    }

    public Attachment withRequestParameter(Map<String, String> map) {
        this.requestParameter = Objects.requireNonNull(map, "request parameter can not be null");
        return this;
    }

    public Attachment withTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = Objects.requireNonNull(templateEngine, "template engine can not be null");
        return this;
    }

    public Attachment withAuthentication(boolean bl) {
        this.requiresAuthentication = bl;
        return this;
    }
}

