/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing;

import com.google.common.net.MediaType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mangoo.constants.Header;
import io.mangoo.utils.JsonUtils;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Response {
    private static final Logger LOG = LogManager.getLogger(Response.class);
    private final Map<HttpString, String> headers = new HashMap<HttpString, String>();
    private final Map<String, Object> content = new HashMap<String, Object>();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private String redirectTo;
    private String contentType = MediaType.HTML_UTF_8.withoutParameters().toString();
    private String body = "";
    private String template;
    private String binaryFileName;
    private byte[] binaryContent;
    private boolean endResponse;
    private boolean binary;
    private boolean rendered;
    private boolean redirect;
    private int statusCode = 200;

    public Response() {
    }

    private Response(int n) {
        this.statusCode = n;
        this.rendered = true;
    }

    private Response(String string) {
        Objects.requireNonNull(string, "redirect to can not be null");
        this.redirect = true;
        this.rendered = false;
        this.redirectTo = string;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getBody() {
        return this.body;
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies);
    }

    public byte[] getBinaryContent() {
        return (byte[])this.binaryContent.clone();
    }

    public String getTemplate() {
        return this.template;
    }

    public String getBinaryFileName() {
        return this.binaryFileName;
    }

    public Map<String, Object> getContent() {
        return this.content;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isRendered() {
        return this.rendered;
    }

    public boolean isEndResponse() {
        return this.endResponse;
    }

    public String getRedirectTo() {
        return this.redirectTo;
    }

    public Map<HttpString, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(HttpString httpString) {
        Objects.requireNonNull(httpString, "header can not be null");
        return this.headers.get(httpString);
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public static Response withOk() {
        return new Response(200);
    }

    public static Response ok() {
        return new Response(200);
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public static Response withCreated() {
        return new Response(201);
    }

    public static Response created() {
        return new Response(201);
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public static Response withNotFound() {
        return new Response(404);
    }

    public static Response notFound() {
        return new Response(404);
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public static Response withForbidden() {
        return new Response(403);
    }

    public static Response forbidden() {
        return new Response(403);
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public static Response withUnauthorized() {
        return new Response(401);
    }

    public static Response unauthorized() {
        return new Response(401);
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public static Response withBadRequest() {
        return new Response(400);
    }

    public static Response badRequest() {
        return new Response(400);
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public static Response withInternalServerError() {
        return new Response(500);
    }

    public static Response internalServerError() {
        return new Response(500);
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public static Response withStatusCode(int n) {
        return new Response(n);
    }

    public static Response status(int n) {
        return new Response(n);
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public static Response withRedirect(String string) {
        return Response.redirect(string);
    }

    public static Response redirect(String string) {
        Objects.requireNonNull(string, "redirect to can not be null");
        return new Response(string);
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andTemplate(String string) {
        Objects.requireNonNull(string, "template can not be null");
        this.template = string;
        return this;
    }

    public Response template(String string) {
        Objects.requireNonNull(string, "template can not be null");
        this.template = string;
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andContentType(String string) {
        Objects.requireNonNull(string, "content type can not be null");
        this.headers.put(Header.CONTENT_TYPE, string);
        this.contentType = string;
        return this;
    }

    public Response contentType(String string) {
        Objects.requireNonNull(string, "content type can not be null");
        this.headers.put(Header.CONTENT_TYPE, string);
        this.contentType = string;
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andContent(String string, Object object) {
        Objects.requireNonNull(string, "name can not be null");
        this.content.put(string, object);
        return this;
    }

    public Response render(String string, Object object) {
        Objects.requireNonNull(string, "name can not be null");
        this.content.put(string, object);
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andHtmlBody(String string) {
        this.body = string;
        this.rendered = false;
        return this;
    }

    public Response bodyHtml(String string) {
        this.body = string;
        this.rendered = false;
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andCookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "cookie can not be null");
        this.cookies.add(cookie);
        return this;
    }

    public Response cookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "cookie can not be null");
        this.cookies.add(cookie);
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andJsonBody(Object object) {
        Objects.requireNonNull(object, "json object can not be null");
        this.body = JsonUtils.toJson(object);
        this.contentType = MediaType.JSON_UTF_8.withoutParameters().toString();
        this.rendered = false;
        return this;
    }

    public Response bodyJson(Object object) {
        Objects.requireNonNull(object, "object can not be null");
        this.body = JsonUtils.toJson(object);
        this.contentType = MediaType.JSON_UTF_8.withoutParameters().toString();
        this.rendered = false;
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andJsonBody(String string) {
        Objects.requireNonNull(string, "json can not be null");
        this.body = string;
        this.contentType = MediaType.JSON_UTF_8.withoutParameters().toString();
        this.rendered = false;
        return this;
    }

    public Response bodyJson(String string) {
        Objects.requireNonNull(string, "json can not be null");
        this.body = string;
        this.contentType = MediaType.JSON_UTF_8.withoutParameters().toString();
        this.rendered = false;
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    @SuppressFBWarnings(justification="null check of file on entry point of method", value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Response andBinaryFile(Path path) {
        Objects.requireNonNull(path, "file can not be null");
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            this.binaryFileName = path.getFileName().toString();
            this.binaryContent = IOUtils.toByteArray((InputStream)inputStream);
            this.binary = true;
            this.rendered = false;
        }
        catch (IOException iOException) {
            LOG.error("Failed to handle binary file", (Throwable)iOException);
        }
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andBinaryContent(byte[] byArray) {
        Objects.requireNonNull(byArray, "content can not be null");
        this.binaryContent = (byte[])byArray.clone();
        this.binary = true;
        this.rendered = false;
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andTextBody(String string) {
        this.body = string;
        this.contentType = MediaType.PLAIN_TEXT_UTF_8.withoutParameters().toString();
        this.rendered = false;
        return this;
    }

    public Response bodyText(String string) {
        this.body = string;
        this.contentType = MediaType.PLAIN_TEXT_UTF_8.withoutParameters().toString();
        this.rendered = false;
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andEmptyBody() {
        this.contentType = MediaType.PLAIN_TEXT_UTF_8.withoutParameters().toString();
        this.rendered = false;
        return this;
    }

    public Response bodyEmpty() {
        this.contentType = MediaType.PLAIN_TEXT_UTF_8.withoutParameters().toString();
        this.rendered = false;
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andHeader(String string, String string2) {
        Objects.requireNonNull(string, "key can not be null");
        this.headers.put(new HttpString(string), string2);
        return this;
    }

    public Response header(String string, String string2) {
        Objects.requireNonNull(string, "key can not be null");
        this.headers.put(new HttpString(string), string2);
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andContent(Map<String, Object> map) {
        Objects.requireNonNull(map, "content can not be null");
        this.content.putAll(map);
        return this;
    }

    public Response render(Map<String, Object> map) {
        Objects.requireNonNull(map, "content can not be null");
        this.content.putAll(map);
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andHeaders(Map<HttpString, String> map) {
        Objects.requireNonNull(map, "headers can not be null");
        this.headers.putAll(map);
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andDisposeCookie(String string) {
        Objects.requireNonNull(string, "cookie can not be null");
        this.cookies.add((Cookie)new CookieImpl(string).setPath("/").setValue("").setMaxAge(Integer.valueOf(-1)).setDiscard(true).setExpires(new Date(1L)));
        return this;
    }

    public Response disposeCookie(String string) {
        Objects.requireNonNull(string, "cookie can not be null");
        this.cookies.add((Cookie)new CookieImpl(string).setPath("/").setValue("").setMaxAge(Integer.valueOf(-1)).setDiscard(true).setExpires(new Date(1L)));
        return this;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public Response andEndResponse() {
        this.endResponse = true;
        return this;
    }

    public Response end() {
        this.endResponse = true;
        return this;
    }
}

