/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mangoo.interfaces.MangooRoute;
import io.mangoo.routing.routes.FileRoute;
import io.mangoo.routing.routes.PathRoute;
import io.mangoo.routing.routes.RequestRoute;
import io.mangoo.routing.routes.ServerSentEventRoute;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

@SuppressFBWarnings(value={"PMB_POSSIBLE_MEMORY_BLOAT"}, justification="Route size is limited")
public final class Router {
    private static Set<MangooRoute> routes = ConcurrentHashMap.newKeySet();
    private static Map<String, RequestRoute> reverseRoutes = new ConcurrentHashMap<String, RequestRoute>();
    private static final int MAX_ROUTES = 100000;

    private Router() {
    }

    public static void addRoute(MangooRoute mangooRoute) {
        RequestRoute requestRoute;
        Objects.requireNonNull(mangooRoute, "route can not be null");
        Preconditions.checkArgument((routes.size() <= 100000 ? 1 : 0) != 0, (Object)"Maximum of 100000 routes reached");
        routes.add(mangooRoute);
        if (mangooRoute instanceof RequestRoute && (requestRoute = (RequestRoute)mangooRoute).getControllerClass() != null && StringUtils.isNotBlank((CharSequence)requestRoute.getControllerMethod())) {
            reverseRoutes.put((requestRoute.getControllerClass().getSimpleName().toLowerCase(Locale.ENGLISH) + ":" + requestRoute.getControllerMethod()).toLowerCase(Locale.ENGLISH), requestRoute);
        }
    }

    public static Set<MangooRoute> getRoutes() {
        return Collections.unmodifiableSet(routes);
    }

    public static Stream<RequestRoute> getRequestRoutes() {
        return routes.stream().filter(RequestRoute.class::isInstance).map(RequestRoute.class::cast).collect(Collectors.toUnmodifiableSet()).stream();
    }

    public static Stream<FileRoute> getFileRoutes() {
        return routes.stream().filter(FileRoute.class::isInstance).map(FileRoute.class::cast).collect(Collectors.toUnmodifiableSet()).stream();
    }

    public static Stream<PathRoute> getPathRoutes() {
        return routes.stream().filter(PathRoute.class::isInstance).map(PathRoute.class::cast).collect(Collectors.toUnmodifiableSet()).stream();
    }

    public static Stream<ServerSentEventRoute> getServerSentEventRoutes() {
        return routes.stream().filter(ServerSentEventRoute.class::isInstance).map(ServerSentEventRoute.class::cast).collect(Collectors.toUnmodifiableSet()).stream();
    }

    public static RequestRoute getReverseRoute(String string) {
        Objects.requireNonNull(string, "key can not be null");
        return reverseRoutes.get(string.toLowerCase(Locale.ENGLISH));
    }

    public static void reset() {
        routes = ConcurrentHashMap.newKeySet();
        reverseRoutes = new ConcurrentHashMap<String, RequestRoute>();
    }
}

