/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.bindings;

import io.mangoo.cache.Cache;
import io.mangoo.cache.CacheProvider;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.utils.CodecUtils;
import io.mangoo.utils.totp.TotpUtils;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class Authentication {
    private LocalDateTime expires;
    private String subject;
    private boolean twoFactor;
    private boolean remember;
    private boolean loggedOut;
    private boolean invalid;

    public static Authentication create() {
        return new Authentication();
    }

    public Authentication withExpires(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "expires can not be null");
        if (this.expires == null) {
            this.expires = localDateTime;
        }
        return this;
    }

    public Authentication withSubject(String string) {
        if (StringUtils.isBlank((CharSequence)this.subject)) {
            this.subject = string;
        }
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public void invalidate() {
        this.invalid = true;
    }

    public LocalDateTime getExpires() {
        return this.expires;
    }

    public boolean isLogout() {
        return this.loggedOut;
    }

    public boolean isRememberMe() {
        return this.remember;
    }

    public boolean isTwoFactor() {
        return this.twoFactor;
    }

    public boolean validLogin(String string, String string2, String string3, String string4) {
        Objects.requireNonNull(string, "username can not be null");
        Objects.requireNonNull(string2, "password can not be null");
        Objects.requireNonNull(string2, "salt can not be null");
        Objects.requireNonNull(string4, "hash can not be null");
        Cache cache = Application.getInstance(CacheProvider.class).getCache("mangooio-auth-cache");
        boolean bl = false;
        if (!this.userHasLock(string) && CodecUtils.matchArgon2(string2, string3, string4)) {
            bl = true;
        } else {
            cache.getAndIncrementCounter(string);
        }
        return bl;
    }

    public Authentication login(String string) {
        this.subject = string;
        return this;
    }

    public Authentication rememberMe(boolean bl) {
        this.remember = bl;
        return this;
    }

    public Authentication rememberMe() {
        this.remember = true;
        return this;
    }

    public Authentication twoFactorAuthentication(boolean bl) {
        this.twoFactor = bl;
        return this;
    }

    public boolean userHasLock(String string) {
        Objects.requireNonNull(string, "username can not be null");
        boolean bl = false;
        Config config = Application.getInstance(Config.class);
        Cache cache = Application.getInstance(CacheProvider.class).getCache("mangooio-auth-cache");
        AtomicInteger atomicInteger = cache.getCounter(string);
        if (atomicInteger != null && atomicInteger.get() > config.getAuthenticationLock()) {
            bl = true;
        }
        return bl;
    }

    public boolean validSecondFactor(String string, String string2) {
        Objects.requireNonNull(string, "secret can not be null");
        Objects.requireNonNull(string2, "totp can not be null");
        return TotpUtils.verifiedTotp(string, string2);
    }

    public void logout() {
        this.loggedOut = true;
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.subject);
    }

    public boolean isInvalid() {
        return this.invalid;
    }
}

