/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.bindings;

import com.google.inject.Inject;
import com.google.re2j.Pattern;
import io.mangoo.core.Application;
import io.mangoo.i18n.Messages;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.commons.validator.routines.UrlValidator;

public class Validator
implements Serializable {
    private static final long serialVersionUID = -714400230978999709L;
    private final Map<String, String> errors = new HashMap<String, String>();
    private final Messages messages;
    protected Map<String, String> values = new HashMap<String, String>();

    @Inject
    public Validator(Messages messages) {
        this.messages = Objects.requireNonNull(messages, "messages can not be null");
    }

    public Validator() {
        this.messages = Application.getInstance(Messages.class);
    }

    public boolean hasError(String string) {
        return this.errors.containsKey(string);
    }

    public String getError(String string) {
        return this.hasError(string) ? this.errors.get(string) : "";
    }

    public void expectValue(String string) {
        this.expectValue(string, null);
    }

    public void expectValue(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (StringUtils.isBlank((CharSequence)StringUtils.trimToNull((String)string3))) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.required", string)));
        }
    }

    public void expectMinValue(String string, double d) {
        this.expectMinValue(string, d, null);
    }

    public void expectMinValue(String string, double d, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (StringUtils.isNumeric((CharSequence)string3)) {
            if (Double.parseDouble(string3) < d) {
                this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.min.value", string, d)));
            }
        } else {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.min.value", string, d)));
        }
    }

    public void expectMinLength(String string, double d) {
        this.expectMinLength(string, d, null);
    }

    public void expectMinLength(String string, double d, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if ((double)string3.length() < d) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.min.length", string, d)));
        }
    }

    public void expectMaxValue(String string, double d) {
        this.expectMaxValue(string, d, null);
    }

    public void expectMaxLength(String string, double d) {
        this.expectMaxLength(string, d, null);
    }

    public void expectNumeric(String string) {
        this.expectNumeric(string, null);
    }

    public void expectNumeric(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!StringUtils.isNumeric((CharSequence)string3)) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.numeric", string)));
        }
    }

    public void expectMaxLength(String string, double d, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if ((double)string3.length() > d) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.max.length", string, d)));
        }
    }

    public void expectMaxValue(String string, double d, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (StringUtils.isNumeric((CharSequence)string3)) {
            if (Double.parseDouble(string3) > d) {
                this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.max.value", string, d)));
            }
        } else {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.max.value", string, d)));
        }
    }

    public void expectExactMatch(String string, String string2) {
        this.expectExactMatch(string, string2, null);
    }

    public void expectExactMatch(String string, String string2, String string3) {
        String string4 = Optional.ofNullable(this.get(string)).orElse("");
        String string5 = Optional.ofNullable(this.get(string2)).orElse("");
        if (StringUtils.isBlank((CharSequence)string4) && StringUtils.isBlank((CharSequence)string5) || StringUtils.isNotBlank((CharSequence)string4) && !string4.equals(string5)) {
            this.addError(string, Optional.ofNullable(string3).orElse(this.messages.get("validation.exactmatch", string, string2)));
        }
    }

    public void expectMatch(String string, String string2) {
        this.expectMatch(string, string2, this.messages.get("validation.match", string, string2));
    }

    public void expectMatch(String string, String string2, String string3) {
        String string4 = Optional.ofNullable(this.get(string)).orElse("");
        String string5 = Optional.ofNullable(this.get(string2)).orElse("");
        if (StringUtils.isBlank((CharSequence)string4) && StringUtils.isBlank((CharSequence)string5) || StringUtils.isNotBlank((CharSequence)string4) && !string4.equalsIgnoreCase(string5)) {
            this.addError(string, Optional.ofNullable(string3).orElse(this.messages.get("validation.match", string, string2)));
        }
    }

    public void expectMatch(String string, List<String> list) {
        this.expectMatch(string, this.messages.get("validation.matchvalues", string), list);
    }

    public void expectMatch(String string, String string2, List<String> list) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!list.contains(string3)) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.matchvalues", string)));
        }
    }

    public void expectEmail(String string) {
        this.expectEmail(string, null);
    }

    public void expectEmail(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!EmailValidator.getInstance().isValid(string3)) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.email", string)));
        }
    }

    public void expectIpv4(String string) {
        this.expectIpv4(string, null);
    }

    public void expectIpv4(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!InetAddressValidator.getInstance().isValidInet4Address(string3)) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.ipv4", string)));
        }
    }

    public void expectDomainName(String string) {
        this.expectDomainName(string, null);
    }

    public void expectDomainName(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!DomainValidator.getInstance().isValid(string3)) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.domainname", string)));
        }
    }

    public void expectIpv6(String string) {
        this.expectIpv6(string, null);
    }

    public void expectIpv6(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!InetAddressValidator.getInstance().isValidInet6Address(string3)) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.ipv6", string)));
        }
    }

    public void expectRangeLength(String string, int n, int n2) {
        this.expectRangeLength(string, n, n2, null);
    }

    public void expectRangeValue(String string, int n, int n2) {
        this.expectRangeValue(string, n, n2, null);
    }

    public void expectRangeValue(String string, int n, int n2, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (StringUtils.isNumeric((CharSequence)string3)) {
            double d = Double.parseDouble(string3);
            if (d < (double)n || d > (double)n2) {
                this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.range.value", string, n, n2)));
            }
        } else {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.range.value", string, n, n2)));
        }
    }

    public void expectRangeLength(String string, int n, int n2, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (string3.length() < n || string3.length() > n2) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.range.length", string, n, n2)));
        }
    }

    public void expectRegex(String string, Pattern pattern) {
        this.expectRegex(string, pattern, null);
    }

    public void expectRegex(String string, Pattern pattern, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!pattern.matcher((CharSequence)string3).matches()) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.regex", string)));
        }
    }

    public void expectUrl(String string) {
        this.expectUrl(string, null);
    }

    public void expectUrl(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!UrlValidator.getInstance().isValid(string3)) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.url", string)));
        }
    }

    public void expectTrue(String string, boolean bl, String string2) {
        if (!bl) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.true", string)));
        }
    }

    public void expectTrue(String string, boolean bl) {
        this.expectTrue(string, bl, null);
    }

    public void expectFalse(String string, boolean bl, String string2) {
        if (bl) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.false", string)));
        }
    }

    public void expectFalse(String string, boolean bl) {
        this.expectFalse(string, bl, null);
    }

    public void expectNotNull(String string, Object object, String string2) {
        if (object == null) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.notnull", string)));
        }
    }

    public void expectNotNull(String string, Object object) {
        this.expectNotNull(string, object, null);
    }

    public void expectNull(String string, Object object, String string2) {
        if (object != null) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get("validation.null", string)));
        }
    }

    public void expectNull(String string, Object object) {
        this.expectNull(string, object, this.messages.get("validation.null", string));
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public String get(String string) {
        Objects.requireNonNull(string, "key can not be null");
        return this.values.get(string);
    }

    private void addError(String string, String string3) {
        Objects.requireNonNull(string, "name can not be null");
        Objects.requireNonNull(string3, "message can not be null");
        this.errors.computeIfAbsent(string, string2 -> string3);
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public void setValues(Map<String, String> map) {
        this.values = map;
    }

    public void addValue(String string, String string2) {
        this.values.put(string, string2);
    }

    public boolean isValid() {
        return !this.hasErrors();
    }

    public void invalidate() {
        this.errors.put("", "");
    }
}

