/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.inject.Key;
import io.mangoo.annotations.FilterWith;
import io.mangoo.core.Application;
import io.mangoo.i18n.Messages;
import io.mangoo.interfaces.filters.OncePerRequestFilter;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.handlers.LocaleHandler;
import io.mangoo.templating.TemplateEngine;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DispatcherHandler
implements HttpHandler {
    private static final Logger LOG = LogManager.getLogger(DispatcherHandler.class);
    private Method method;
    private List<Annotation> methodAnnotations = new ArrayList<Annotation>();
    private List<Annotation> classAnnotations = new ArrayList<Annotation>();
    private TemplateEngine templateEngine;
    private Messages messages;
    private Map<String, Class<?>> methodParameters;
    private Class<?> controllerClass;
    private String controllerClassName;
    private String controllerMethodName;
    private String username;
    private String password;
    private int limit;
    private int methodParametersCount;
    private boolean requestFilter;
    private boolean blocking;
    private boolean authentication;

    public DispatcherHandler dispatch(Class<?> clazz, String string) {
        Objects.requireNonNull(clazz, "controller class can not be null");
        Objects.requireNonNull(string, "controller method can not be null");
        this.templateEngine = Application.getInstance(TemplateEngine.class);
        this.messages = Application.getInstance(Messages.class);
        this.controllerClass = clazz;
        this.controllerMethodName = string;
        this.controllerClassName = clazz.getSimpleName();
        this.methodParameters = this.getMethodParameters();
        this.methodParametersCount = this.methodParameters.size();
        this.requestFilter = Application.getInjector().getAllBindings().containsKey(Key.get(OncePerRequestFilter.class));
        try {
            this.method = Application.getInstance(this.controllerClass).getClass().getDeclaredMethod(this.controllerMethodName, this.methodParameters.values().toArray(new Class[0]));
            for (Annotation annotation : this.method.getAnnotations()) {
                if (!annotation.annotationType().equals(FilterWith.class)) continue;
                this.methodAnnotations.add(annotation);
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            LOG.error("Failed to create DispatcherHandler", (Throwable)exception);
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!annotation.annotationType().equals(FilterWith.class)) continue;
            this.classAnnotations.add(annotation);
        }
        return this;
    }

    public DispatcherHandler isBlocking(boolean bl) {
        this.blocking = bl;
        return this;
    }

    public DispatcherHandler withBasicAuthentication(String string, String string2) {
        this.username = string;
        this.password = string2;
        return this;
    }

    public DispatcherHandler withAuthentication(boolean bl) {
        this.authentication = bl;
        return this;
    }

    public DispatcherHandler withLimit(int n) {
        this.limit = n;
        return this;
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        if ((RequestUtils.isPostPutPatch(httpServerExchange) || this.blocking) && httpServerExchange.isInIoThread()) {
            httpServerExchange.dispatch((HttpHandler)this);
            return;
        }
        Attachment attachment = Attachment.build().withControllerInstance(Application.getInstance(this.controllerClass)).withControllerClass(this.controllerClass).withControllerClassName(this.controllerClassName).withControllerMethodName(this.controllerMethodName).withClassAnnotations(this.classAnnotations).withMethodAnnotations(this.methodAnnotations).withMethodParameters(this.methodParameters).withMethod(this.method).withMethodParameterCount(this.methodParametersCount).withRequestFilter(this.requestFilter).withRequestParameter(RequestUtils.getRequestParameters(httpServerExchange)).withMessages(this.messages).withLimit(this.limit).withAuthentication(this.authentication).withBasicAuthentication(this.username, this.password).withTemplateEngine(this.templateEngine);
        httpServerExchange.putAttachment(RequestUtils.getAttachmentKey(), (Object)attachment);
        this.nextHandler(httpServerExchange);
    }

    private Map<String, Class<?>> getMethodParameters() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Method method : this.controllerClass.getDeclaredMethods()) {
            if (!method.getName().equals(this.controllerMethodName) || method.getParameterCount() <= 0) continue;
            Arrays.stream(method.getParameters()).forEach(parameter -> linkedHashMap.put(parameter.getName(), parameter.getType()));
            break;
        }
        return linkedHashMap;
    }

    private void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.password)) {
            HttpHandler httpHandler = RequestUtils.wrapBasicAuthentication(Application.getInstance(LocaleHandler.class), this.username, this.password);
            httpHandler.handleRequest(httpServerExchange);
        } else {
            Application.getInstance(LocaleHandler.class).handleRequest(httpServerExchange);
        }
    }
}

