/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.common.net.MediaType;
import io.mangoo.constants.Header;
import io.mangoo.constants.Template;
import io.mangoo.core.Application;
import io.mangoo.core.Server;
import io.mangoo.templating.TemplateEngine;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExceptionHandler
implements HttpHandler {
    private static final Logger LOG = LogManager.getLogger(ExceptionHandler.class);

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        Throwable throwable = (Throwable)httpServerExchange.getAttachment(io.undertow.server.handlers.ExceptionHandler.THROWABLE);
        if (throwable != null) {
            LOG.error("Internal Server Exception", throwable);
        }
        try {
            Server.headers().entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).forEach(entry -> httpServerExchange.getResponseHeaders().add((HttpString)entry.getKey(), (String)entry.getValue()));
            httpServerExchange.getResponseHeaders().put(Header.CONTENT_TYPE, MediaType.HTML_UTF_8.withoutParameters().toString());
            httpServerExchange.setStatusCode(500);
            if (Application.inDevMode()) {
                TemplateEngine templateEngine = new TemplateEngine();
                if (throwable == null) {
                    httpServerExchange.getResponseSender().send(Template.serverError());
                } else if (throwable.getCause() == null) {
                    httpServerExchange.getResponseSender().send(templateEngine.renderException(httpServerExchange, throwable, true));
                } else {
                    httpServerExchange.getResponseSender().send(templateEngine.renderException(httpServerExchange, throwable.getCause(), false));
                }
            } else {
                httpServerExchange.getResponseSender().send(Template.serverError());
            }
        }
        catch (Exception exception) {
            LOG.error("Failed to pass an exception to the frontend", (Throwable)exception);
        }
    }
}

