/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.inject.Inject;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.exceptions.MangooTokenException;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.bindings.Authentication;
import io.mangoo.routing.bindings.Flash;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.bindings.Session;
import io.mangoo.routing.handlers.AuthenticationHandler;
import io.mangoo.utils.CodecUtils;
import io.mangoo.utils.MangooUtils;
import io.mangoo.utils.RequestUtils;
import io.mangoo.utils.token.Token;
import io.mangoo.utils.token.TokenParser;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InboundCookiesHandler
implements HttpHandler {
    private static final Logger LOG = LogManager.getLogger(InboundCookiesHandler.class);
    private final Config config;
    private Form form;

    @Inject
    public InboundCookiesHandler(Config config) {
        this.config = Objects.requireNonNull(config, "config can not be null");
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        Attachment attachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.getAttachmentKey());
        attachment.setSession(this.getSessionCookie(httpServerExchange));
        attachment.setAuthentication(this.getAuthenticationCookie(httpServerExchange));
        attachment.setFlash(this.getFlashCookie(httpServerExchange));
        attachment.setForm(this.form);
        httpServerExchange.putAttachment(RequestUtils.getAttachmentKey(), (Object)attachment);
        this.nextHandler(httpServerExchange);
    }

    protected Session getSessionCookie(HttpServerExchange httpServerExchange) {
        Session session = Session.create().withContent(new HashMap<String, String>()).withExpires(LocalDateTime.now().plusMinutes(this.config.getSessionCookieTokenExpires()));
        String string = this.getCookieValue(httpServerExchange, this.config.getSessionCookieName());
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                Token token = TokenParser.create().withSharedSecret(this.config.getSessionCookieSecret()).withCookieValue(string).parse();
                if (token.expirationIsAfter(LocalDateTime.now())) {
                    session = Session.create().withContent(MangooUtils.copyMap(token.getClaim("data", Map.class))).withExpires(token.getExpiration());
                }
            }
            catch (MangooTokenException mangooTokenException) {
                LOG.debug("Failed to parse session cookie", (Throwable)mangooTokenException);
                session.invalidate();
            }
        }
        return session;
    }

    protected Authentication getAuthenticationCookie(HttpServerExchange httpServerExchange) {
        Authentication authentication = Authentication.create().withSubject(null).withExpires(LocalDateTime.now().plusMinutes(this.config.getAuthenticationCookieTokenExpires()));
        String string = this.getCookieValue(httpServerExchange, this.config.getAuthenticationCookieName());
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                Token token = TokenParser.create().withSharedSecret(this.config.getAuthenticationCookieSecret()).withCookieValue(string).parse();
                if (token.expirationIsAfter(LocalDateTime.now())) {
                    authentication = Authentication.create().withExpires(token.getExpiration()).withSubject(token.getSubject()).twoFactorAuthentication(Boolean.parseBoolean(token.getClaim("twoFactor", String.class)));
                }
            }
            catch (MangooTokenException mangooTokenException) {
                LOG.debug("Failed to parse authentication cookie", (Throwable)mangooTokenException);
                authentication.invalidate();
            }
        }
        return authentication;
    }

    protected Flash getFlashCookie(HttpServerExchange httpServerExchange) {
        Flash flash = Flash.create();
        String string = this.getCookieValue(httpServerExchange, this.config.getFlashCookieName());
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                Token token = TokenParser.create().withSharedSecret(this.config.getFlashCookieSecret()).withCookieValue(string).parse();
                if (token.expirationIsAfter(LocalDateTime.now())) {
                    if (token.containsClaim("form")) {
                        this.form = (Form)CodecUtils.deserializeFromBase64(token.getClaim("form", String.class));
                    }
                    flash = Flash.create().withContent(MangooUtils.copyMap((Map)token.getPaseto().getClaims().get("data", Map.class))).setDiscard(true);
                }
            }
            catch (MangooTokenException mangooTokenException) {
                LOG.debug("Failed to parse flash cookie", (Throwable)mangooTokenException);
                flash.invalidate();
            }
        }
        return flash;
    }

    private String getCookieValue(HttpServerExchange httpServerExchange, String string) {
        String string2 = null;
        Cookie cookie = httpServerExchange.getRequestCookie(string);
        if (cookie != null) {
            string2 = cookie.getValue();
        }
        return string2;
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(AuthenticationHandler.class).handleRequest(httpServerExchange);
    }
}

