/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.inject.Inject;
import io.mangoo.constants.Header;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.handlers.InboundCookiesHandler;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.LocaleUtils;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class LocaleHandler
implements HttpHandler {
    private final Config config;

    @Inject
    public LocaleHandler(Config config) {
        this.config = Objects.requireNonNull(config, "config can not be null");
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        Object object;
        Locale locale = Locale.forLanguageTag(this.config.getApplicationLanguage());
        Cookie cookie = httpServerExchange.getRequestCookie(this.config.getI18nCookieName());
        if (cookie != null) {
            locale = LocaleUtils.getLocaleFromString((String)cookie.getValue());
        } else {
            String string;
            object = httpServerExchange.getRequestHeaders().get(Header.ACCEPT_LANGUAGE);
            if (object != null && StringUtils.isNotBlank((CharSequence)(string = object.element()))) {
                locale = LocaleUtils.getLocaleFromString((String)string);
            }
        }
        object = (Attachment)httpServerExchange.getAttachment(RequestUtils.getAttachmentKey());
        ((Attachment)object).getMessages().reload(locale);
        ((Attachment)object).withLocale(locale);
        httpServerExchange.putAttachment(RequestUtils.getAttachmentKey(), object);
        this.nextHandler(httpServerExchange);
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(InboundCookiesHandler.class).handleRequest(httpServerExchange);
    }
}

