/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.inject.Inject;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.bindings.Authentication;
import io.mangoo.routing.bindings.Flash;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.bindings.Session;
import io.mangoo.routing.handlers.CorsHandler;
import io.mangoo.routing.handlers.ResponseHandler;
import io.mangoo.utils.CodecUtils;
import io.mangoo.utils.DateUtils;
import io.mangoo.utils.RequestUtils;
import io.mangoo.utils.token.TokenBuilder;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import java.time.LocalDateTime;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutboundCookiesHandler
implements HttpHandler {
    private static final Logger LOG = LogManager.getLogger(OutboundCookiesHandler.class);
    private static final String SAME_SITE_MODE = "Strict";
    private static final int SIXTY = 60;
    private final Config config;
    private Attachment attachment;

    @Inject
    public OutboundCookiesHandler(Config config) {
        this.config = Objects.requireNonNull(config, "config can not be null");
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        this.attachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.getAttachmentKey());
        this.setSessionCookie(httpServerExchange);
        this.setFlashCookie(httpServerExchange);
        this.setAuthenticationCookie(httpServerExchange);
        this.nextHandler(httpServerExchange);
    }

    protected void setSessionCookie(HttpServerExchange httpServerExchange) {
        Session session = this.attachment.getSession();
        if (session.isInvalid()) {
            Cookie cookie = new CookieImpl(this.config.getSessionCookieName()).setSecure(this.config.isSessionCookieSecure()).setValue("").setHttpOnly(true).setPath("/").setMaxAge(Integer.valueOf(0)).setSameSite(true).setSameSiteMode(SAME_SITE_MODE).setDiscard(true);
            httpServerExchange.setResponseCookie(cookie);
        } else if (session.hasChanges()) {
            try {
                String string = TokenBuilder.create().withExpires(session.getExpires()).withSharedSecret(this.config.getSessionCookieSecret()).withClaim("data", session.getValues()).build();
                Cookie cookie = new CookieImpl(this.config.getSessionCookieName()).setValue(string).setSameSite(true).setSameSiteMode(SAME_SITE_MODE).setHttpOnly(true).setPath("/").setSecure(this.config.isSessionCookieSecure());
                if (Boolean.TRUE.equals(this.config.isSessionCookieExpires())) {
                    cookie.setExpires(DateUtils.localDateTimeToDate(session.getExpires()));
                }
                httpServerExchange.setResponseCookie(cookie);
            }
            catch (Exception exception) {
                LOG.error("Failed to generate session cookie", (Throwable)exception);
            }
        }
    }

    protected void setAuthenticationCookie(HttpServerExchange httpServerExchange) {
        Authentication authentication = this.attachment.getAuthentication();
        if (authentication.isInvalid() || authentication.isLogout()) {
            Cookie cookie = new CookieImpl(this.config.getAuthenticationCookieName()).setSecure(this.config.isAuthenticationCookieSecure()).setValue("").setHttpOnly(true).setPath("/").setMaxAge(Integer.valueOf(0)).setSameSite(true).setSameSiteMode(SAME_SITE_MODE).setDiscard(true);
            httpServerExchange.setResponseCookie(cookie);
        } else if (authentication.isValid()) {
            if (authentication.isRememberMe()) {
                authentication.withExpires(LocalDateTime.now().plusHours(this.config.getAuthenticationCookieRememberExpires()));
            }
            try {
                String string = TokenBuilder.create().withExpires(authentication.getExpires()).withSharedSecret(this.config.getAuthenticationCookieSecret()).withClaim("twoFactor", (Object)String.valueOf(authentication.isTwoFactor())).withSubject(authentication.getSubject()).build();
                Cookie cookie = new CookieImpl(this.config.getAuthenticationCookieName()).setValue(string).setSecure(this.config.isAuthenticationCookieSecure()).setHttpOnly(true).setSameSite(true).setPath("/").setSameSiteMode(SAME_SITE_MODE);
                if (this.config.isAuthenticationCookieExpires()) {
                    cookie.setExpires(DateUtils.localDateTimeToDate(authentication.getExpires()));
                }
                httpServerExchange.setResponseCookie(cookie);
            }
            catch (Exception exception) {
                LOG.error("Failed to generate authentication cookie", (Throwable)exception);
            }
        }
    }

    protected void setFlashCookie(HttpServerExchange httpServerExchange) {
        Flash flash = this.attachment.getFlash();
        Form form = this.attachment.getForm();
        if (flash.isDiscard() || flash.isInvalid()) {
            Cookie cookie = new CookieImpl(this.config.getFlashCookieName()).setHttpOnly(true).setValue("").setSecure(this.config.isFlashCookieSecure()).setPath("/").setSameSite(true).setSameSiteMode(SAME_SITE_MODE).setDiscard(true).setMaxAge(Integer.valueOf(0));
            httpServerExchange.setResponseCookie(cookie);
        } else if (flash.hasContent() || form.isKept()) {
            try {
                LocalDateTime localDateTime = LocalDateTime.now().plusSeconds(60L);
                TokenBuilder tokenBuilder = TokenBuilder.create().withExpires(localDateTime).withSharedSecret(this.config.getFlashCookieSecret()).withClaim("data", flash.getValues());
                if (form.isKept()) {
                    tokenBuilder.withClaim("form", (Object)CodecUtils.serializeToBase64(form));
                }
                String string = tokenBuilder.build();
                Cookie cookie = new CookieImpl(this.config.getFlashCookieName()).setValue(string).setSecure(this.config.isFlashCookieSecure()).setHttpOnly(true).setSameSite(true).setPath("/").setSameSiteMode(SAME_SITE_MODE).setExpires(DateUtils.localDateTimeToDate(localDateTime));
                httpServerExchange.setResponseCookie(cookie);
            }
            catch (Exception exception) {
                LOG.error("Failed to generate flash cookie", (Throwable)exception);
            }
        }
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        if (this.config.isCorsEnable()) {
            Application.getInstance(CorsHandler.class).handleRequest(httpServerExchange);
        } else {
            Application.getInstance(ResponseHandler.class).handleRequest(httpServerExchange);
        }
    }
}

