/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mangoo.annotations.FilterWith;
import io.mangoo.core.Application;
import io.mangoo.enums.Binding;
import io.mangoo.exceptions.MangooTemplateEngineException;
import io.mangoo.interfaces.filters.OncePerRequestFilter;
import io.mangoo.interfaces.filters.PerRequestFilter;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Request;
import io.mangoo.routing.handlers.OutboundCookiesHandler;
import io.mangoo.templating.TemplateContext;
import io.mangoo.utils.JsonUtils;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class RequestHandler
implements HttpHandler {
    private static final String FILTER_METHOD = "execute";
    private Attachment attachment;

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        this.attachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.getAttachmentKey());
        this.attachment.setBody(this.getRequestBody(httpServerExchange));
        this.attachment.setRequest(this.getRequest(httpServerExchange));
        Response response = this.getResponse(httpServerExchange);
        response.getCookies().forEach(arg_0 -> ((HttpServerExchange)httpServerExchange).setResponseCookie(arg_0));
        this.attachment.setResponse(response);
        httpServerExchange.putAttachment(RequestUtils.getAttachmentKey(), (Object)this.attachment);
        this.nextHandler(httpServerExchange);
    }

    protected Request getRequest(HttpServerExchange httpServerExchange) {
        return new Request(httpServerExchange).withSession(this.attachment.getSession()).withAuthentication(this.attachment.getAuthentication()).withParameter(this.attachment.getRequestParameter()).withBody(this.attachment.getBody());
    }

    protected Response getResponse(HttpServerExchange httpServerExchange) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, MangooTemplateEngineException {
        Response response = Response.withOk();
        if (this.attachment.hasRequestFilter()) {
            OncePerRequestFilter oncePerRequestFilter = Application.getInstance(OncePerRequestFilter.class);
            response = oncePerRequestFilter.execute(this.attachment.getRequest(), response);
        }
        if (response.isEndResponse()) {
            return response;
        }
        response = this.executeFilter(this.attachment.getClassAnnotations(), response);
        if (response.isEndResponse()) {
            return response;
        }
        response = this.executeFilter(this.attachment.getMethodAnnotations(), response);
        if (response.isEndResponse()) {
            return response;
        }
        if (response.isRedirect()) {
            return response;
        }
        return this.invokeController(httpServerExchange, response);
    }

    protected Response invokeController(HttpServerExchange httpServerExchange, Response response) throws IllegalAccessException, InvocationTargetException, MangooTemplateEngineException {
        Object object;
        Response response2;
        if (this.attachment.getMethodParameters().isEmpty()) {
            response2 = (Response)this.attachment.getMethod().invoke(this.attachment.getControllerInstance(), new Object[0]);
        } else {
            object = this.getConvertedParameters(httpServerExchange);
            response2 = (Response)this.attachment.getMethod().invoke(this.attachment.getControllerInstance(), object);
        }
        response2.andContent(response.getContent());
        response2.andHeaders(response.getHeaders());
        if (response2.isRendered()) {
            object = new TemplateContext(response2.getContent()).withFlash(this.attachment.getFlash()).withSession(this.attachment.getSession()).withForm(this.attachment.getForm()).withMessages(this.attachment.getMessages()).withController(this.attachment.getControllerAndMethod()).withPrettyTime(this.attachment.getLocale()).withTemplatePath(this.getTemplatePath(response2));
            response2.andHtmlBody(this.attachment.getTemplateEngine().renderTemplate((TemplateContext)object));
        }
        return response2;
    }

    protected String getTemplatePath(Response response) {
        return StringUtils.isBlank((CharSequence)response.getTemplate()) ? this.attachment.getControllerClassName() + "/" + this.attachment.getTemplateEngine().getTemplateName(this.attachment.getControllerMethodName()) : response.getTemplate();
    }

    @SuppressFBWarnings(justification="Intentionally adding unrelated types", value={"UCC_UNRELATED_COLLECTION_CONTENTS"})
    protected Object[] getConvertedParameters(HttpServerExchange httpServerExchange) {
        Object[] objectArray = new Object[this.attachment.getMethodParametersCount()];
        int n = 0;
        for (Map.Entry<String, Class<?>> entry : this.attachment.getMethodParameters().entrySet()) {
            String string = entry.getKey();
            Class<?> clazz = entry.getValue();
            Binding binding = Optional.ofNullable(Binding.fromString(clazz.getName())).orElse(Binding.UNDEFINED);
            objectArray[n] = switch (binding) {
                case Binding.FORM -> this.attachment.getForm();
                case Binding.AUTHENTICATION -> this.attachment.getAuthentication();
                case Binding.SESSION -> this.attachment.getSession();
                case Binding.FLASH -> this.attachment.getFlash();
                case Binding.REQUEST -> this.attachment.getRequest();
                case Binding.MESSAGES -> this.attachment.getMessages();
                case Binding.LOCAL_DATE -> {
                    if (StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string))) {
                        yield null;
                    }
                    yield LocalDate.parse(this.attachment.getRequestParameter().get(string));
                }
                case Binding.LOCAL_DATE_TIME -> {
                    if (StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string))) {
                        yield null;
                    }
                    yield LocalDateTime.parse(this.attachment.getRequestParameter().get(string));
                }
                case Binding.STRING -> {
                    if (StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string))) {
                        yield null;
                    }
                    yield this.attachment.getRequestParameter().get(string);
                }
                case Binding.INT_PRIMITIVE -> StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? 0 : Integer.parseInt(this.attachment.getRequestParameter().get(string));
                case Binding.INTEGER -> {
                    if (StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string))) {
                        yield null;
                    }
                    yield Integer.valueOf(this.attachment.getRequestParameter().get(string));
                }
                case Binding.DOUBLE_PRIMITIVE -> StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? 0.0 : Double.parseDouble(this.attachment.getRequestParameter().get(string));
                case Binding.DOUBLE -> {
                    if (StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string))) {
                        yield null;
                    }
                    yield Double.valueOf(this.attachment.getRequestParameter().get(string));
                }
                case Binding.FLOAT_PRIMITIVE -> Float.valueOf(StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? 0.0f : Float.parseFloat(this.attachment.getRequestParameter().get(string)));
                case Binding.FLOAT -> {
                    if (StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string))) {
                        yield null;
                    }
                    yield Float.valueOf(this.attachment.getRequestParameter().get(string));
                }
                case Binding.LONG_PRIMITIVE -> StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? 0L : Long.parseLong(this.attachment.getRequestParameter().get(string));
                case Binding.LONG -> {
                    if (StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string))) {
                        yield null;
                    }
                    yield Long.valueOf(this.attachment.getRequestParameter().get(string));
                }
                case Binding.OPTIONAL -> {
                    if (StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string))) {
                        yield Optional.empty();
                    }
                    yield Optional.of(this.attachment.getRequestParameter().get(string));
                }
                case Binding.UNDEFINED -> {
                    if (RequestUtils.isJsonRequest(httpServerExchange)) {
                        yield JsonUtils.toObject(this.attachment.getBody(), clazz);
                    }
                    yield null;
                }
                default -> null;
            };
            ++n;
        }
        return objectArray;
    }

    protected Response executeFilter(List<Annotation> list, Response response) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (Annotation annotation : list) {
            FilterWith filterWith = (FilterWith)annotation;
            for (Class<? extends PerRequestFilter> clazz : filterWith.value()) {
                if (response.isEndResponse()) {
                    return response;
                }
                Method method = clazz.getMethod(FILTER_METHOD, Request.class, Response.class);
                response = (Response)method.invoke((Object)Application.getInstance(clazz), this.attachment.getRequest(), response);
            }
        }
        return response;
    }

    protected String getRequestBody(HttpServerExchange httpServerExchange) throws IOException {
        String string = "";
        if (RequestUtils.isPostPutPatch(httpServerExchange)) {
            httpServerExchange.startBlocking();
            string = IOUtils.toString((InputStream)httpServerExchange.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        return string;
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(OutboundCookiesHandler.class).handleRequest(httpServerExchange);
    }
}

