/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.listeners;

import io.mangoo.core.Application;
import io.mangoo.models.Metrics;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class MetricsListener
implements ExchangeCompletionListener {
    private long start;

    public MetricsListener() {
    }

    public MetricsListener(long l) {
        this.start = l;
    }

    public void exchangeEvent(HttpServerExchange httpServerExchange, ExchangeCompletionListener.NextListener nextListener) {
        String string = Optional.ofNullable(httpServerExchange.getRequestURI()).orElse("").toLowerCase(Locale.ENGLISH);
        if (StringUtils.isNotBlank((CharSequence)string) && !string.contains("@admin")) {
            int n = (int)(System.currentTimeMillis() - this.start);
            Metrics metrics = Application.getInstance(Metrics.class);
            metrics.update(n);
            metrics.addStatusCode(httpServerExchange.getStatusCode());
            long l = httpServerExchange.getResponseContentLength();
            if (l > 0L) {
                metrics.incrementDataSend(l);
            }
        }
        nextListener.proceed();
    }
}

