/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.routes;

import io.mangoo.enums.Http;
import io.mangoo.interfaces.MangooRoute;
import io.mangoo.routing.Router;
import io.mangoo.routing.routes.RequestRoute;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ControllerRoute {
    private final Class<?> controllerClass;
    private String username;
    private String password;
    private boolean authentication;
    private boolean blocking;

    public ControllerRoute(Class<?> clazz) {
        Objects.requireNonNull(clazz, "controller class can not be null");
        this.controllerClass = clazz;
    }

    public void withRoutes(MangooRoute ... mangooRouteArray) {
        Objects.requireNonNull(mangooRouteArray, "route can not be null");
        for (MangooRoute mangooRoute : mangooRouteArray) {
            RequestRoute requestRoute = (RequestRoute)mangooRoute;
            requestRoute.withControllerClass(this.controllerClass);
            if (this.hasBasicAuthentication()) {
                requestRoute.withBasicAuthentication(this.username, this.password);
            }
            if (this.hasAuthentication()) {
                requestRoute.withAuthentication();
            }
            if (this.hasBlocking()) {
                requestRoute.withNonBlocking();
            }
            if (requestRoute.hasMultipleMethods()) {
                for (Http http : requestRoute.getMethods()) {
                    requestRoute.withHttpMethod(http);
                    Router.addRoute(requestRoute);
                }
                continue;
            }
            Router.addRoute(requestRoute);
        }
    }

    public ControllerRoute withBasicAuthentication(String string, String string2) {
        Objects.requireNonNull(string, "username can not be null");
        Objects.requireNonNull(string2, "password can not be null");
        this.username = string;
        this.password = string2;
        return this;
    }

    public ControllerRoute withAuthentication() {
        this.authentication = true;
        return this;
    }

    public ControllerRoute withNonBlocking() {
        this.blocking = true;
        return this;
    }

    public boolean hasAuthentication() {
        return this.authentication;
    }

    public boolean hasBlocking() {
        return this.blocking;
    }

    public boolean hasBasicAuthentication() {
        return StringUtils.isNotBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.password);
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

