/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.routes;

import io.mangoo.enums.Http;
import io.mangoo.interfaces.MangooRoute;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RequestRoute
implements MangooRoute {
    private Class<?> controllerClass;
    private Http[] methods = new Http[0];
    private Http method;
    private String url;
    private String controllerMethod;
    private String username;
    private String password;
    private boolean blocking;
    private boolean authentication;

    public RequestRoute(Http http) {
        Objects.requireNonNull(http, "HTTP method can not be null");
        this.method = http;
    }

    public RequestRoute(Http ... httpArray) {
        Objects.requireNonNull(httpArray, "HTTP method can not be null");
        this.methods = Arrays.copyOf(httpArray, httpArray.length);
    }

    public RequestRoute to(String object) {
        Objects.requireNonNull(object, "url can not be null");
        if ('/' != ((String)object).charAt(0)) {
            object = "/" + (String)object;
        }
        this.url = object;
        return this;
    }

    public RequestRoute respondeWith(String string) {
        Objects.requireNonNull(string, "controller method can not be null");
        this.controllerMethod = string;
        return this;
    }

    public void withControllerClass(Class<?> clazz) {
        Objects.requireNonNull(clazz, "controller class can not be null");
        this.controllerClass = clazz;
    }

    public void withHttpMethod(Http http) {
        Objects.requireNonNull(http, "method can not be null");
        this.method = http;
    }

    public RequestRoute withBasicAuthentication(String string, String string2) {
        Objects.requireNonNull(string, "username can not be null");
        Objects.requireNonNull(string2, "password can not be null");
        this.username = string;
        this.password = string2;
        return this;
    }

    public RequestRoute withAuthentication() {
        this.authentication = true;
        return this;
    }

    public RequestRoute withNonBlocking() {
        this.blocking = true;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public boolean hasAuthentication() {
        return this.authentication;
    }

    public boolean hasBasicAuthentication() {
        return StringUtils.isNotBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean hasMultipleMethods() {
        return this.methods != null && this.methods.length > 0;
    }

    public Http[] getMethods() {
        return Arrays.copyOf(this.methods, this.methods.length);
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public String getControllerMethod() {
        return this.controllerMethod;
    }

    public Http getMethod() {
        return this.method;
    }

    public boolean isBlocking() {
        return this.blocking;
    }
}

