/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.scheduler;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import io.mangoo.core.Application;
import io.mangoo.scheduler.Task;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CronTask
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(CronTask.class);
    private final Class<?> clazz;
    private final String methodName;
    private final ExecutionTime executionTime;

    public CronTask(Class<?> clazz, String string, String string2) {
        Objects.requireNonNull(string2, "cron can no be null");
        this.clazz = Objects.requireNonNull(clazz, "class can not be null");
        this.methodName = Objects.requireNonNull(string, "method can not be null");
        this.executionTime = ExecutionTime.forCron((Cron)new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX)).parse(string2));
    }

    @Override
    public void run() {
        try {
            long l = this.delay();
            if (l > 0L) {
                Task task = new Task(this.clazz, this.methodName);
                Application.getScheduledExecutorService().schedule(task, l, TimeUnit.SECONDS).get();
            }
        }
        catch (Exception exception) {
            LOG.error("Failed to execute scheduled cron task on class '{}' with annotated method '{}'", (Object)this.clazz.getName(), (Object)this.methodName, (Object)exception);
        }
        this.run();
    }

    private long delay() throws ExecutionException, InterruptedException {
        if (this.secondsToNextExecution() == 0L) {
            try (ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, Thread.ofVirtual().factory());){
                scheduledExecutorService.schedule(() -> {}, 1L, TimeUnit.SECONDS).get();
            }
        }
        return this.secondsToNextExecution();
    }

    private long secondsToNextExecution() {
        return this.executionTime.timeToNextExecution(ZonedDateTime.now()).orElse(Duration.ofSeconds(-1L)).getSeconds();
    }
}

