/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.scheduler;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Schedule {
    private final String clazz;
    private final String method;
    private final String runAt;
    private final ScheduledFuture<?> scheduledFuture;
    private final boolean cron;

    private Schedule(String string, String string2, String string3, ScheduledFuture<?> scheduledFuture, boolean bl) {
        this.clazz = Objects.requireNonNull(string, "clazz cannot be null");
        this.method = Objects.requireNonNull(string2, "method cannot be null");
        this.runAt = Objects.requireNonNull(string3, "runAt cannot be null");
        this.scheduledFuture = Objects.requireNonNull(scheduledFuture, "scheduledFuture cannot be null");
        this.cron = bl;
    }

    public static Schedule of(String string, String string2, String string3, ScheduledFuture<?> scheduledFuture, boolean bl) {
        return new Schedule(string, string2, string3, scheduledFuture, bl);
    }

    public ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    public LocalDateTime next() {
        if (this.cron) {
            ExecutionTime executionTime = ExecutionTime.forCron((Cron)new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX)).parse(this.runAt));
            long l = executionTime.timeToNextExecution(ZonedDateTime.now()).orElse(Duration.ofSeconds(-1L)).getSeconds();
            return LocalDateTime.now().plusSeconds(l);
        }
        return LocalDateTime.now().plusSeconds(this.scheduledFuture.getDelay(TimeUnit.SECONDS));
    }

    public String getRunAt() {
        return this.runAt;
    }

    public String getMethod() {
        return this.method;
    }

    public String getClazz() {
        return this.clazz.replace("class", "").trim();
    }
}

