/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.templating;

import io.mangoo.i18n.Messages;
import io.mangoo.routing.bindings.Flash;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.bindings.Session;
import io.mangoo.templating.methods.I18nMethod;
import io.mangoo.templating.methods.LocationMethod;
import io.mangoo.templating.methods.PrettyTimeMethod;
import io.mangoo.templating.methods.RouteMethod;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class TemplateContext {
    private String templatePath;
    private Map<String, Object> content = new HashMap<String, Object>();

    public TemplateContext() {
        this.content.put("route", new RouteMethod());
    }

    public TemplateContext(Map<String, Object> map) {
        this.content = map;
        map.put("route", new RouteMethod());
    }

    public TemplateContext withForm(Form form) {
        this.content.put("form", form);
        return this;
    }

    public TemplateContext withFlash(Flash flash) {
        this.content.put("flash", flash);
        return this;
    }

    public TemplateContext withSession(Session session) {
        this.content.put("session", session);
        return this;
    }

    public TemplateContext withMessages(Messages messages) {
        this.content.put("i18n", new I18nMethod(messages));
        return this;
    }

    public TemplateContext withController(String string) {
        this.content.put("location", new LocationMethod(string));
        return this;
    }

    public TemplateContext withPrettyTime(Locale locale) {
        this.content.put("prettytime", new PrettyTimeMethod(locale));
        return this;
    }

    public TemplateContext withTemplatePath(String string) {
        this.templatePath = string;
        return this;
    }

    public TemplateContext addContent(String string, Object object) {
        this.content.put(string, object);
        return this;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public Map<String, Object> getContent() {
        return this.content;
    }
}

