/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.templating.methods;

import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import io.mangoo.i18n.Messages;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class I18nMethod
implements TemplateMethodModelEx {
    private static final Logger LOG = LogManager.getLogger(I18nMethod.class);
    private static final int NUM_ARGUMENTS = 1;
    private final Messages messages;

    public I18nMethod(Messages messages) {
        this.messages = messages;
    }

    public TemplateModel exec(List list) throws TemplateModelException {
        String string = "";
        if (list.size() == 1) {
            String string2 = ((SimpleScalar)list.getFirst()).getAsString();
            string = this.messages.get(string2);
        } else if (list.size() > 1) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object e : list) {
                if (e instanceof SimpleScalar) {
                    SimpleScalar simpleScalar = (SimpleScalar)e;
                    arrayList.add(simpleScalar.getAsString());
                    continue;
                }
                if (e instanceof SimpleNumber) {
                    SimpleNumber simpleNumber = (SimpleNumber)e;
                    arrayList.add(simpleNumber.toString());
                    continue;
                }
                LOG.warn("Argument can only be of type SimpleScalar or SimpleNumber. Is: {}", e.getClass());
            }
            String string3 = (String)arrayList.getFirst();
            arrayList.removeFirst();
            string = this.messages.get(string3, arrayList.toArray());
        } else {
            LOG.warn("Invalid number of arguments for i18n");
        }
        return new SimpleScalar(string);
    }
}

