/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import io.fury.Fury;
import io.fury.ThreadSafeFury;
import io.fury.config.Language;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.bouncycastle.util.Arrays;

public final class CodecUtils {
    private static final Base64.Encoder BASE64ENCODER = Base64.getEncoder();
    private static final Base64.Decoder BASE64DECODER = Base64.getDecoder();
    private static final ThreadSafeFury FURY = Fury.builder().withLanguage(Language.JAVA).requireClassRegistration(false).buildThreadSafeFury();
    private static final int ITERATIONS = 20;
    private static final int MEMORY = 16777;
    private static final int PARALLELISM = 4;

    private CodecUtils() {
    }

    public static String hashArgon2(String string, String string2) {
        Objects.requireNonNull(string, "password can not be null");
        Objects.requireNonNull(string2, "salt can not be null");
        Argon2Parameters.Builder builder = new Argon2Parameters.Builder().withVersion(2).withIterations(20).withMemoryAsKB(16777).withParallelism(4).withSecret(string.getBytes(StandardCharsets.UTF_8)).withSalt(string2.getBytes(StandardCharsets.UTF_8));
        Argon2BytesGenerator argon2BytesGenerator = new Argon2BytesGenerator();
        argon2BytesGenerator.init(builder.build());
        byte[] byArray = new byte[32];
        argon2BytesGenerator.generateBytes(string.getBytes(StandardCharsets.UTF_8), byArray);
        return BASE64ENCODER.encodeToString(byArray);
    }

    public static boolean matchArgon2(String string, String string2, String string3) {
        Objects.requireNonNull(string, "password can not be null");
        Objects.requireNonNull(string2, "salt can not be null");
        Objects.requireNonNull(string3, "password can not be null");
        return Arrays.areEqual((byte[])CodecUtils.hashArgon2(string, string2).getBytes(StandardCharsets.UTF_8), (byte[])string3.getBytes(StandardCharsets.UTF_8));
    }

    public static String hexSHA512(String string) {
        Objects.requireNonNull(string, "data can not be null");
        return DigestUtils.sha512Hex((String)string);
    }

    public static String serializeToBase64(Serializable serializable) {
        Objects.requireNonNull(serializable, "object can not be null");
        byte[] byArray = FURY.serialize((Object)serializable);
        return BASE64ENCODER.encodeToString(byArray);
    }

    public static <T> T deserializeFromBase64(String string) {
        Objects.requireNonNull(string, "data can not be null");
        byte[] byArray = BASE64DECODER.decode(string);
        return (T)FURY.deserialize(byArray);
    }

    public static byte[] encodeToBase64(String string) {
        Objects.requireNonNull(string, "data can not be null");
        return BASE64ENCODER.encode(string.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] decodeFromBase64(String string) {
        Objects.requireNonNull(string, "data can not be null");
        return BASE64DECODER.decode(string);
    }
}

