/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JsonUtils {
    private static final Logger LOG = LogManager.getLogger(JsonUtils.class);
    private static final ObjectMapper MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).addModule((Module)new AfterburnerModule())).addModule((Module)new JavaTimeModule())).build();

    private JsonUtils() {
    }

    public static String toJson(Object object) {
        Objects.requireNonNull(object, "object can not be null");
        String string = "";
        try {
            string = MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            LOG.error("Failed to convert object to json", (Throwable)jsonProcessingException);
        }
        return string;
    }

    public static String toPrettyJson(Object object) {
        Objects.requireNonNull(object, "object can not be null");
        String string = "";
        try {
            string = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            LOG.error("Failed to convert object to json", (Throwable)jsonProcessingException);
        }
        return string;
    }

    @Deprecated(since="8.5.0", forRemoval=true)
    public static <T> T fromJson(String string, Class<T> clazz) {
        Objects.requireNonNull(string, "json can not be null");
        Objects.requireNonNull(clazz, "class can not be null");
        Object object = null;
        try {
            object = MAPPER.readValue(string, clazz);
        }
        catch (IOException iOException) {
            LOG.error("Failed to convert json to object class", (Throwable)iOException);
        }
        return (T)object;
    }

    public static <T> T toObject(String string, Class<T> clazz) {
        Objects.requireNonNull(string, "json can not be null");
        Objects.requireNonNull(clazz, "class can not be null");
        Object object = null;
        try {
            object = MAPPER.readValue(string, clazz);
        }
        catch (IOException iOException) {
            LOG.error("Failed to convert json to object class", (Throwable)iOException);
        }
        return (T)object;
    }

    public static Map<String, String> toFlatMap(String string) {
        Objects.requireNonNull(string, "json can not be null");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            JsonUtils.addKeys("", new ObjectMapper().readTree(string), hashMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    private static void addKeys(String string, JsonNode jsonNode, Map<String, String> map) {
        if (jsonNode.isObject()) {
            Object object;
            ObjectNode objectNode = (ObjectNode)jsonNode;
            Iterator iterator = objectNode.fields();
            Object object2 = object = string.isEmpty() ? "" : string + ".";
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                JsonUtils.addKeys((String)object + (String)entry.getKey(), (JsonNode)entry.getValue(), map);
            }
        } else if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (int i = 0; i < arrayNode.size(); ++i) {
                JsonUtils.addKeys(string + "[" + i + "]", arrayNode.get(i), map);
            }
        } else if (jsonNode.isValueNode()) {
            ValueNode valueNode = (ValueNode)jsonNode;
            map.put(string, valueNode.asText());
        }
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

