/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MangooUtils {
    private static final Logger LOG = LogManager.getLogger(MangooUtils.class);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final String[] UNITS = new String[]{"B", "kB", "MB", "GB", "TB"};
    private static final String VERSION_PROPERTIES = "version.properties";
    private static final String VERSION_UNKNOWN = "unknown";
    private static final char[] CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    private static final int MAX_LENGTH = 256;
    private static final int MIN_LENGTH = 0;
    private static final int CONVERSION = 1024;

    private MangooUtils() {
    }

    @SuppressFBWarnings(justification="Only used to retrieve the version of mangoo I/O", value={"URLCONNECTION_SSRF_FD"})
    public static String getVersion() {
        String string = VERSION_UNKNOWN;
        try (InputStream inputStream = Resources.getResource((String)VERSION_PROPERTIES).openStream();){
            Properties properties = new Properties();
            properties.load(inputStream);
            string = String.valueOf(properties.get("version"));
        }
        catch (IOException iOException) {
            LOG.error("Failed to get application version", (Throwable)iOException);
        }
        return string;
    }

    public static Map<String, String> copyMap(Map<String, String> map) {
        Objects.requireNonNull(map, "map can not be null");
        return new HashMap<String, String>(map);
    }

    public static String randomString(int n) {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"random string length must be at least 1 character");
        Preconditions.checkArgument((n <= 256 ? 1 : 0) != 0, (Object)"random string length must be at most 256 character");
        return RandomStringUtils.random((int)n, (int)0, (int)(CHARACTERS.length - 1), (boolean)false, (boolean)false, (char[])CHARACTERS, (Random)SECURE_RANDOM);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            LOG.error("Failed to close resource quietly", (Throwable)iOException);
        }
    }

    public static String readableFileSize(long l) {
        if (l <= 0L) {
            return "0";
        }
        int n = (int)(Math.log10(l) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)l / Math.pow(1024.0, n)) + " " + UNITS[n];
    }

    public static boolean resourceExists(String string) {
        Objects.requireNonNull(string, "name can not be null");
        URL uRL = null;
        try {
            uRL = Resources.getResource((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uRL != null;
    }

    public static String readFileToString(Path path) {
        Objects.requireNonNull(path, "path can not be null");
        String string = "";
        try {
            string = Files.readString(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public static String readFileToString(String string) {
        Objects.requireNonNull(string, "path can not be null");
        return MangooUtils.readFileToString(Path.of(string, new String[0]));
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String readResourceToString(String string) {
        Objects.requireNonNull(string, "resource can not be null");
        String string2 = "";
        try {
            string2 = Resources.toString((URL)Resources.getResource((String)string), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }
}

