/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.google.common.net.MediaType;
import com.google.re2j.Pattern;
import io.mangoo.constants.Header;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.exceptions.MangooTokenException;
import io.mangoo.models.Identity;
import io.mangoo.routing.Attachment;
import io.mangoo.utils.token.TokenParser;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.Methods;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RequestUtils {
    private static final Logger LOG = LogManager.getLogger(RequestUtils.class);
    private static final Pattern PATTERN = Pattern.compile((String)"\"");
    private static AttachmentKey<Attachment> attachmentKey;

    private RequestUtils() {
    }

    public static AttachmentKey<Attachment> getAttachmentKey() {
        if (attachmentKey == null) {
            attachmentKey = AttachmentKey.create(Attachment.class);
        }
        return attachmentKey;
    }

    public static Map<String, String> getRequestParameters(HttpServerExchange httpServerExchange) {
        Objects.requireNonNull(httpServerExchange, "httpServerExchange can not be null");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map map = httpServerExchange.getQueryParameters();
        map.putAll(httpServerExchange.getPathParameters());
        map.forEach((string, deque) -> hashMap.put((String)string, (String)deque.element()));
        return hashMap;
    }

    public static boolean isPostPutPatch(HttpServerExchange httpServerExchange) {
        Objects.requireNonNull(httpServerExchange, "httpServerExchange can not be null");
        return Methods.POST.equals(httpServerExchange.getRequestMethod()) || Methods.PUT.equals(httpServerExchange.getRequestMethod()) || Methods.PATCH.equals(httpServerExchange.getRequestMethod());
    }

    public static boolean isJsonRequest(HttpServerExchange httpServerExchange) {
        Objects.requireNonNull(httpServerExchange, "httpServerExchange can not be null");
        HeaderMap headerMap = httpServerExchange.getRequestHeaders();
        return headerMap != null && headerMap.get(Header.CONTENT_TYPE) != null && headerMap.get(Header.CONTENT_TYPE).element().toLowerCase(Locale.ENGLISH).contains(MediaType.JSON_UTF_8.withoutParameters().toString());
    }

    public static boolean hasValidAuthentication(String string) {
        boolean bl = false;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            String[] stringArray;
            Config config = Application.getInstance(Config.class);
            String string2 = null;
            for (String string3 : stringArray = string.split(";")) {
                if (!StringUtils.isNotBlank((CharSequence)string3) || !string3.startsWith(config.getAuthenticationCookieName())) continue;
                string2 = StringUtils.substringAfter((String)string3, (String)(config.getAuthenticationCookieName() + "="));
                string2 = PATTERN.matcher((CharSequence)string2).replaceAll("");
            }
            if (StringUtils.isNotBlank(string2)) {
                try {
                    TokenParser.create().withSharedSecret(config.getAuthenticationCookieSecret()).withCookieValue(string2).parse();
                    bl = true;
                }
                catch (MangooTokenException mangooTokenException) {
                    LOG.error("Failed to parse authentication cookie", (Throwable)mangooTokenException);
                }
            }
        }
        return bl;
    }

    public static HttpHandler wrapBasicAuthentication(HttpHandler httpHandler, String string, String string2) {
        Objects.requireNonNull(httpHandler, "httpHandler can not be null");
        Objects.requireNonNull(string, "username can not be null");
        Objects.requireNonNull(string2, "password can not be null");
        AuthenticationCallHandler authenticationCallHandler = new AuthenticationCallHandler(httpHandler);
        authenticationCallHandler = new AuthenticationConstraintHandler((HttpHandler)authenticationCallHandler);
        authenticationCallHandler = new AuthenticationMechanismsHandler((HttpHandler)authenticationCallHandler, Collections.singletonList(new BasicAuthenticationMechanism("Authentication required")));
        return new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, (IdentityManager)new Identity(string, string2), (HttpHandler)authenticationCallHandler);
    }
}

