/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils.token;

import dev.paseto.jpaseto.Paseto;
import io.mangoo.constants.ClaimKey;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;

public class Token {
    private final Paseto paseto;

    public Token(Paseto paseto) {
        this.paseto = Objects.requireNonNull(paseto, "paseto can not be null");
    }

    public LocalDateTime getExpiration() {
        return LocalDateTime.ofInstant(this.paseto.getClaims().getExpiration(), ZoneOffset.UTC);
    }

    public boolean containsClaim(ClaimKey claimKey) {
        Objects.requireNonNull(claimKey, "claim key can not be null");
        return this.containsClaim(claimKey);
    }

    public boolean containsClaim(String string) {
        Objects.requireNonNull(string, "key can not be null");
        return this.paseto.getClaims().containsKey((Object)string);
    }

    public boolean expirationIsAfter(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "localDateTime can not be null");
        return this.getExpiration().isAfter(localDateTime);
    }

    public <T> T getClaim(ClaimKey claimKey, Class<T> clazz) {
        Objects.requireNonNull(claimKey, "claim key can not be null");
        Objects.requireNonNull(clazz, "class can not be null");
        return this.getClaim(claimKey, clazz);
    }

    public <T> T getClaim(String string, Class<T> clazz) {
        Objects.requireNonNull(string, "key can not be null");
        Objects.requireNonNull(clazz, "class can not be null");
        return (T)this.paseto.getClaims().get(string, clazz);
    }

    public String getSubject() {
        return this.paseto.getClaims().getSubject();
    }

    public Paseto getPaseto() {
        return this.paseto;
    }
}

