/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils.token;

import dev.paseto.jpaseto.PasetoV2LocalBuilder;
import dev.paseto.jpaseto.Pasetos;
import io.mangoo.constants.ClaimKey;
import io.mangoo.exceptions.MangooTokenException;
import io.mangoo.utils.MangooUtils;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class TokenBuilder {
    private static final String ALGORITHM = "AES";
    private final Map<String, Object> claims = new HashMap<String, Object>();
    private LocalDateTime expires;
    private String sharedSecret;
    private String subject;

    public static TokenBuilder create() {
        return new TokenBuilder();
    }

    public TokenBuilder withExpires(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "expires can not be null");
        this.expires = localDateTime;
        return this;
    }

    public TokenBuilder withSharedSecret(String string) {
        Objects.requireNonNull(string, "sharedCecret can not be null");
        this.sharedSecret = string;
        return this;
    }

    public TokenBuilder withClaim(ClaimKey claimKey, Object object) {
        this.withClaim(claimKey, object);
        return this;
    }

    public TokenBuilder withClaim(String string, Object object) {
        Objects.requireNonNull(string, "key can not be null");
        this.claims.put(string, object);
        return this;
    }

    public TokenBuilder withSubject(String string) {
        this.subject = string;
        return this;
    }

    public LocalDateTime getExpires() {
        return this.expires;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public String getSubject() {
        return this.subject;
    }

    public String build() throws MangooTokenException {
        try {
            PasetoV2LocalBuilder pasetoV2LocalBuilder = ((PasetoV2LocalBuilder)((PasetoV2LocalBuilder)Pasetos.V2.LOCAL.builder().setExpiration(this.expires.toInstant(ZoneOffset.UTC))).setSubject(this.subject == null ? MangooUtils.randomString(32) : this.subject)).setSharedSecret((SecretKey)new SecretKeySpec(this.sharedSecret.getBytes(StandardCharsets.UTF_8), ALGORITHM));
            for (Map.Entry<String, Object> entry : this.claims.entrySet()) {
                pasetoV2LocalBuilder.claim(entry.getKey(), entry.getValue());
            }
            return pasetoV2LocalBuilder.compact();
        }
        catch (Exception exception) {
            throw new MangooTokenException(exception);
        }
    }
}

