/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils.token;

import dev.paseto.jpaseto.Paseto;
import dev.paseto.jpaseto.PasetoException;
import dev.paseto.jpaseto.Pasetos;
import io.mangoo.exceptions.MangooTokenException;
import io.mangoo.utils.token.Token;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class TokenParser {
    private String sharedSecret;
    private String cookieValue;

    public static TokenParser create() {
        return new TokenParser();
    }

    public TokenParser withSharedSecret(String string) {
        Objects.requireNonNull(string, "sharedCecret can not be null");
        this.sharedSecret = string;
        return this;
    }

    public TokenParser withCookieValue(String string) {
        Objects.requireNonNull(string, "cookievalue can not be null");
        this.cookieValue = string;
        return this;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public String getCookieValue() {
        return this.cookieValue;
    }

    public Token parse() throws MangooTokenException {
        try {
            Paseto paseto = Pasetos.parserBuilder().setSharedSecret(this.sharedSecret.getBytes(StandardCharsets.UTF_8)).build().parse(this.cookieValue);
            return new Token(paseto);
        }
        catch (PasetoException pasetoException) {
            throw new MangooTokenException((Exception)((Object)pasetoException));
        }
    }
}

