/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils.totp;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Range;
import com.google.common.io.BaseEncoding;
import io.mangoo.utils.totp.Totp;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.GeneralSecurityException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class TotpBuilder {
    public static final long DEFAULT_TIME_STEP = TimeUnit.SECONDS.toMillis(30L);
    public static final int DEFAULT_DIGITS = 6;
    public static final int MIN_ALLOWED_DIGITS = 6;
    public static final int MAX_ALLOWED_DIGITS = 8;
    private final byte[] key;
    private long timeStep = DEFAULT_TIME_STEP;
    private int digits = 6;
    private String hmacShaAlgorithm = "SHA256";

    TotpBuilder(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        this.key = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.key, 0, byArray.length);
    }

    public TotpBuilder timeStep(long l) {
        Preconditions.checkArgument((l > 0L ? 1 : 0) != 0);
        this.timeStep = l;
        return this;
    }

    public TotpBuilder digits(int n) {
        Preconditions.checkArgument((boolean)Range.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(8)).contains((Comparable)Integer.valueOf(n)));
        this.digits = n;
        return this;
    }

    public TotpBuilder hmacSha(String string) {
        Preconditions.checkNotNull((Object)string);
        this.hmacShaAlgorithm = string;
        return this;
    }

    public TotpBuilder hmacSha256() {
        return this.hmacSha("SHA256");
    }

    public TotpBuilder hmacSha512() {
        return this.hmacSha("SHA512");
    }

    public Totp build() {
        long l = System.currentTimeMillis();
        return new Totp(this.generateTOTP(l), l, this.hmacShaAlgorithm, this.digits, this.timeStep);
    }

    public Totp build(long l) {
        Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0);
        return new Totp(this.generateTOTP(l), l, this.hmacShaAlgorithm, this.digits, this.timeStep);
    }

    private byte[] computeHmacSha(byte[] byArray, byte[] byArray2) {
        try {
            Mac mac = Mac.getInstance("HmacSHA512");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "RAW");
            mac.init(secretKeySpec);
            return mac.doFinal(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new UndeclaredThrowableException(generalSecurityException);
        }
    }

    private String generateTOTP(long l) {
        long l2 = (long)Math.floor(l / this.timeStep);
        String string = Strings.padStart((String)Long.toHexString(l2).toUpperCase(Locale.ENGLISH), (int)16, (char)'0');
        byte[] byArray = BaseEncoding.base16().decode((CharSequence)string);
        byte[] byArray2 = this.computeHmacSha(this.key, byArray);
        int n = byArray2[byArray2.length - 1] & 0xF;
        int n2 = (byArray2[n] & 0x7F) << 24 | (byArray2[n + 1] & 0xFF) << 16 | (byArray2[n + 2] & 0xFF) << 8 | byArray2[n + 3] & 0xFF;
        int n3 = n2 % (int)Math.pow(10.0, this.digits);
        return Strings.padStart((String)Integer.toString(n3), (int)this.digits, (char)'0');
    }
}

