/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils.totp;

import io.mangoo.utils.totp.Totp;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang3.RegExUtils;

public class TotpUtils {
    private static final Base32 base32 = new Base32();
    private static final Random random = new SecureRandom();
    private static final String ALGORITHM = "SHA512";
    private static final int DIGITS = 6;
    private static final int MAX_CHARACTERS = 32;
    private static final int PERIOD = 30;
    private static final int ITERATIONS = 26;
    private static final int BYTES_SECRET = 64;

    private TotpUtils() {
    }

    public static String createSecret() {
        StringBuilder stringBuilder = new StringBuilder(64);
        for (int i = 0; i < 64; ++i) {
            int n = random.nextInt(32);
            if (n < 26) {
                stringBuilder.append((char)(65 + n));
                continue;
            }
            stringBuilder.append((char)(50 + (n - 26)));
        }
        return stringBuilder.toString();
    }

    public static String getTotp(String string) {
        Objects.requireNonNull(string, "secret can not be null");
        Totp totp = Totp.key(string.getBytes(StandardCharsets.US_ASCII)).timeStep(TimeUnit.SECONDS.toMillis(30L)).digits(6).hmacSha(ALGORITHM).build();
        return totp.value();
    }

    public static String getTotp(String string, String string2, int n, int n2) {
        Objects.requireNonNull(string, "secret can not be null");
        Objects.requireNonNull(string2, "algorithm can not be null");
        Totp totp = Totp.key(string.getBytes(StandardCharsets.US_ASCII)).timeStep(TimeUnit.SECONDS.toMillis(n2)).digits(n).hmacSha(string2).build();
        return totp.value();
    }

    public static boolean verifiedTotp(String string, String string2) {
        Objects.requireNonNull(string, "secret can not be null");
        Objects.requireNonNull(string2, "totp can not be null");
        Totp totp = Totp.key(string.getBytes(StandardCharsets.US_ASCII)).timeStep(TimeUnit.SECONDS.toMillis(30L)).digits(6).hmacSha(ALGORITHM).build();
        return string2.equals(totp.value());
    }

    public static String getQRCode(String string, String string2, String string3, String string4, String string5, String string6) {
        Objects.requireNonNull(string, "account name can not be null");
        Objects.requireNonNull(string3, "secret can not be null");
        Objects.requireNonNull(string2, "issuer can not be null");
        Objects.requireNonNull(string4, "algorithm can not be null");
        Objects.requireNonNull(string5, "digits can not be null");
        Objects.requireNonNull(string6, "period can not be null");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=").append(TotpUtils.getOtpauthURL(string, string2, string3, string4, string5, string6));
        return stringBuilder.toString();
    }

    public static String getOtpauthURL(String string, String string2, String string3, String string4, String string5, String string6) {
        Objects.requireNonNull(string, "account name can not be null");
        Objects.requireNonNull(string3, "secret can not be null");
        Objects.requireNonNull(string2, "issuer can not be null");
        Objects.requireNonNull(string4, "algorithm can not be null");
        Objects.requireNonNull(string5, "digits can not be null");
        Objects.requireNonNull(string6, "period can not be null");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("otpauth://totp/").append(string).append("?secret=").append(RegExUtils.replaceAll((String)base32.encodeAsString(string3.getBytes(StandardCharsets.UTF_8)), (String)"=", (String)"")).append("&algorithm=").append(string4).append("&issuer=").append(string2).append("&digits=").append(string5).append("&period=").append(string6);
        String string7 = "";
        string7 = URLEncoder.encode(stringBuilder.toString(), StandardCharsets.UTF_8);
        return string7;
    }
}

