/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils.totp;

import com.google.common.base.Preconditions;
import io.mangoo.utils.totp.Totp;
import io.mangoo.utils.totp.TotpBuilder;

public final class TotpValidator {
    public static final int DEFAULT_WINDOW = 1;
    private final int window;

    private TotpValidator(int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0);
        this.window = n;
    }

    public static TotpValidator defaultWindow() {
        return TotpValidator.window(1);
    }

    public static TotpValidator window(int n) {
        return new TotpValidator(n);
    }

    public boolean isValid(byte[] byArray, long l, int n, String string, String string2) {
        return this.isValid(byArray, l, n, string, string2, System.currentTimeMillis());
    }

    public boolean isValid(byte[] byArray, long l, int n, String string, String string2, long l2) {
        boolean bl = false;
        TotpBuilder totpBuilder = Totp.key(byArray).timeStep(l).digits(n).hmacSha(string);
        for (int i = -this.window; i <= this.window; ++i) {
            long l3 = l2 + (long)i * l;
            Totp totp = totpBuilder.build(l3);
            if (!totp.value().equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

