/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;

public class Dependencies {
    private static final String REPO = "https://repo.maven.apache.org/maven2/";
    private static final String WORKDIR = System.getProperty("user.dir");
    private static final String DEPENDENCIES_FILE = WORKDIR + "/dependencies.properties";
    private static final String LIB_FOLDER = WORKDIR + "/lib/";

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(Paths.get(DEPENDENCIES_FILE, new String[0]), new OpenOption[0]);){
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        for (Map.Entry entry : properties.entrySet()) {
            String string = (String)entry.getValue();
            String[] stringArray2 = string.split(":");
            String string2 = stringArray2[0].replace('.', '/');
            String string3 = stringArray2[1];
            String string4 = stringArray2[2];
            String string5 = string3 + "-" + string4 + ".jar";
            String string6 = REPO + string2 + "/" + string3 + "/" + string4 + "/" + string5;
            Path path = Paths.get(LIB_FOLDER + string5, new String[0]);
            if (Files.exists(path, new LinkOption[0])) continue;
            Dependencies.deletePreviousVersion(string3);
            try {
                InputStream inputStream = new URL(string6).openStream();
                try {
                    Files.copy(inputStream, Paths.get(LIB_FOLDER + string5, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static void deletePreviousVersion(String string) {
        try (Stream<Path> stream = Files.list(Paths.get(LIB_FOLDER, new String[0]));){
            stream.filter(path -> path.toFile().getName().contains(string)).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

